<?php

defined( 'ABSPATH' ) || die( 'No direct script access allowed!' );


class W3ExAdvBulkEditView{

	private static $ins = null;
	private $attributes      = array();
	private $attributes_asoc = array();
	private $variations_fields = array();
	private $categories = array();
	private $cat_asoc = array();
	private $largeattributes = array();
	private $iswpml = false;
	private $isversion3 = false;

	public static function lang_category_id($id,$taxname)
	{
	  if(function_exists('icl_object_id'))
	  {
	    return icl_object_id($id,$taxname,false);
	  }else
	  {
	  	if(has_filter('wpml_object_id'))
	  	{
			return apply_filters( 'wpml_object_id', $id, $taxname ,FALSE);
		}else
	    	return $id;
	  }
	}

    public static function init()
    {
       self::instance()->_main();
    }

    public static function instance()
    {
        is_null(self::$ins) && self::$ins = new self;
        return self::$ins;
    }

    public static function relpaceInvalid($str)
    {
    	$str = strip_tags($str);
        $str = str_replace('"','\"',$str);
      	$str = preg_replace('#\R+#', ' ', $str);
        return $str;
    }

	public function mb_ucfirst($p_str)
	{
		if (function_exists('mb_substr') && function_exists('mb_strtoupper') && function_exists('mb_strlen'))
		{
			$string = $p_str;
			if(mb_strlen($p_str) > 0)
			{
			    $string = mb_strtoupper(mb_substr($p_str, 0, 1)) . mb_substr($p_str, 1);
			}
		    return $string;
		}else
		{
			return ucfirst($p_str);
		}
	}

	public function LoadAttributeTerms(&$attr,$name,$iter,$bcat = false,$skiploadfrontpage = false)
	{
		global $wpdb;
		$offset = $iter * 1000;
		$iter++;
		$limit = "LIMIT 1000 OFFSET {$offset}";
		$attrprefix = "";
		if($name !== 'product_tag' && !$bcat)
		{
			$attrprefix = "pa_";
		}
		$getquery = "SELECT t.name,tt.term_taxonomy_id FROM {$wpdb->prefix}terms as t INNER JOIN {$wpdb->prefix}term_taxonomy AS tt ON t.term_id= tt.term_id WHERE tt.taxonomy IN('".$attrprefix. $name ."') ORDER BY t.slug ASC {$limit}";
		if($skiploadfrontpage)
		{
			$getquery = "SELECT t.term_id,t.name,t.slug,tt.term_taxonomy_id FROM {$wpdb->prefix}terms as t INNER JOIN {$wpdb->prefix}term_taxonomy AS tt ON t.term_id= tt.term_id WHERE tt.taxonomy IN('".$attrprefix. $name ."') ORDER BY t.slug ASC {$limit}";
		}
		if($bcat)
		{
			$getquery = "SELECT t.term_id,t.name,t.slug,tt.term_taxonomy_id,tt.parent FROM {$wpdb->prefix}terms as t INNER JOIN {$wpdb->prefix}term_taxonomy AS tt ON t.term_id= tt.term_id WHERE tt.taxonomy IN('". $name ."') ORDER BY t.slug ASC {$limit}";
		}

		$values = $wpdb->get_results($getquery);
		if(is_wp_error($values))
			return false;
		foreach($values as $val){
			if(!is_object($val)) continue;
			if(!property_exists($val,'term_taxonomy_id')) continue;
			if($bcat)
			{
		    	if(!property_exists($val,'term_id')) continue;
				$cat = new stdClass();
				$cat->category_id     = $val->term_taxonomy_id;
				if($this->iswpml)
				{
				   if(ICL_LANGUAGE_CODE != 'all')
				   {
				   	   $id = self::lang_category_id($cat->category_id,$name);
					   if($id === NULL || $id != $cat->category_id)
					   		continue;
				   }
			    }
				$cat->term_id         = $val->term_id;
				$cat->category_name   = $val->name;
				$cat->category_slug   = urldecode($val->slug);
				$cat->category_parent = $val->parent;
				$this->categories[] = $cat;
				$this->cat_asoc[$cat->category_id] = $cat;
				continue;
			}

			$value          = new stdClass();
			$value->id      = $val->term_taxonomy_id;
			if($this->iswpml)
			{
			   if(ICL_LANGUAGE_CODE != 'all')
			   {
			   	   $id = self::lang_category_id($val->term_taxonomy_id,$attrprefix.$name);
				   if($id === NULL || $id != $val->term_taxonomy_id)
				   		continue;
			   }
		    }
			$value->term_id      = $val->term_id;
			if($skiploadfrontpage)
			{
				$value->slug    = $val->slug;
				$value->name    = $val->name;
			}

			$attr->values[]  = $value;
		}
		if(count($values) === 1000)
		{
			$curr_settings = get_option('w3exabe_settings');
			if(!is_array($curr_settings))
				$curr_settings = array();

			$largetemp = array();
			if(isset($curr_settings['largeattributes']) && is_array($curr_settings['largeattributes']))
			{
				$largetemp = $curr_settings['largeattributes'];
				if(isset($largetemp[$name]) && $largetemp[$name] === "0")
				{
					return;
				}
			}
			$this->LoadAttributeTerms($attr,$name,$iter,$bcat,$skiploadfrontpage);
		}
	}

	public function loadAttributes($skiploadfrontpage = false)
	{
		//categories
		$args = array(
		    'number'     => 99999,
		    'orderby'    => 'slug',
		    'order'      => 'ASC',
		    'hide_empty' => false,
		    'include'    => '',
			'fields'     => 'all',
			'taxonomy'   => 'product_cat'
		);
		{
			$this->LoadAttributeTerms($args,'product_cat',0,true);
		}



		$curr_settings = get_option('w3exabe_settings');
		if(!is_array($curr_settings))
			$curr_settings = array();

		$largetemp = array();
		if(isset($curr_settings['largeattributes']) && is_array($curr_settings['largeattributes']))
		{
			$largetemp = $curr_settings['largeattributes'];
		}
		if(isset($curr_settings['disattributes']))
		{
			if($curr_settings['disattributes'] == 1)
				return;
		}
	    global $wpdb;

		$woo_attrs = $wpdb->get_results("select * from " . $wpdb->prefix . "woocommerce_attribute_taxonomies order by attribute_name",ARRAY_A);
		$counter = 0;

		foreach($woo_attrs as $attr)
		{
			$counter++;
			$att         = new stdClass();
			$att->id     = $attr['attribute_id'];
			$att->name   = $attr['attribute_name'];
			if(function_exists('wc_sanitize_taxonomy_name'))
				$att->name = wc_sanitize_taxonomy_name($attr['attribute_name']);
			$att->label  = $attr['attribute_label'];
			if(!$att->label)
				$att->label = ucfirst($att->name);
			$att->type   = $attr['attribute_type'];


			$att->values = array();
			$args = array(
							    'number'     => 99999,
							    'orderby'    => 'slug',
							    'order'      => 'ASC',
							    'hide_empty' => false,
							    'include'    => '',
								'fields'     => 'all'
							);


			$this->LoadAttributeTerms($att,$att->name,0,false,$skiploadfrontpage);

			$skip = false;
		 	if(count($att->values) > 0)
			{
				if(count($att->values) >= 2000)
				{
					if(!isset($largetemp[$att->name]))
					{
						$largetemp[$att->name] = "0";
					}
					$this->largeattributes[$att->name] = array();
					$this->largeattributes[$att->name]['name'] = $att->name;
					$this->largeattributes[$att->name]['label'] = $att->label;
					$this->largeattributes[$att->name]['status'] = $largetemp[$att->name];
					if(isset($largetemp[$att->name]) && $largetemp[$att->name] === "0")
					{
						$att->values = array();
						$skip = true;
					}
				}
				if(count($att->values) < 2000 && count($att->values) >= 100)
				{
					$this->largeattributes[$att->name] = array();
					$this->largeattributes[$att->name]['name'] = $att->name;
					$this->largeattributes[$att->name]['label'] = $att->label;
					if(!isset($largetemp[$att->name]))
					{
						$this->largeattributes[$att->name]['status'] = "1";
					}else
					{
						$this->largeattributes[$att->name]['status'] = $largetemp[$att->name];
					}
					if(isset($largetemp[$att->name]) && $largetemp[$att->name] === "0")
					{
						$att->values = array();
						$skip = true;
					}

				}
				if(!$skip)
					$this->attributes[]  = $att;
			}
		}
		$curr_settings['largeattributes'] = $largetemp;
		update_option('w3exabe_settings',$curr_settings);
	}

	public function loadTranslations(&$arr)
	{
		$arr['post_excerpt'] = esc_html__( 'Product Short Description', 'woocommerce-advbulkedit');
		if($arr['post_excerpt'] === "Product Short Description")
			$arr['post_excerpt'] = esc_html__( 'Product Short Description', 'woocommerce');
		$arr['post_content'] = esc_html__( 'Description', 'woocommerce-advbulkedit');
		if($arr['post_content'] === "Description")
			$arr['post_content'] = esc_html__( 'Description', 'woocommerce');
		$arr['_thumbnail_id'] = esc_html__( 'Image', 'woocommerce-advbulkedit');
		if($arr['_thumbnail_id'] === "Image")
			$arr['_thumbnail_id'] = esc_html__( 'Image', 'woocommerce');
		$arr['_product_image_gallery'] = esc_html__( 'Product Gallery', 'woocommerce-advbulkedit');
		if($arr['_product_image_gallery'] === "Product Gallery")
			$arr['_product_image_gallery'] = esc_html__( 'Product Gallery', 'woocommerce');
		$arr['_sku'] = esc_html__( 'SKU', 'woocommerce-advbulkedit');
		if($arr['_sku'] === "SKU")
			$arr['_sku'] = esc_html__( 'SKU', 'woocommerce');
		$arr['post_name'] = esc_html__( 'Slug', 'woocommerce-advbulkedit');
		if($arr['post_name'] === "Slug")
			$arr['post_name'] = esc_html__( 'Slug', 'woocommerce');
		$arr['product_tag'] = esc_html__( 'Tags', 'woocommerce-advbulkedit');
		if($arr['product_tag'] === "Tags")
			$arr['product_tag'] = esc_html__( 'Tags', 'woocommerce');
		$arr['_virtual'] = esc_html__( 'Virtual', 'woocommerce-advbulkedit');
		if($arr['_virtual'] === "Virtual")
			$arr['_virtual'] = esc_html__( 'Virtual', 'woocommerce');
		$arr['_downloadable'] = esc_html__( 'Downloadable', 'woocommerce-advbulkedit');
		if($arr['_downloadable'] === "Downloadable")
			$arr['_downloadable'] = esc_html__( 'Downloadable', 'woocommerce');
		$arr['post_title'] = esc_html__( 'Title', 'woocommerce-advbulkedit');
		if($arr['post_title'] === "Title")
			$arr['post_title'] = esc_html__( 'Title', 'woocommerce');
		$arr['product_cat'] = esc_html__( 'Categories', 'woocommerce-advbulkedit');
		if($arr['product_cat'] === "Categories")
			$arr['product_cat'] = esc_html__( 'Categories', 'woocommerce');
		$arr['_regular_price'] = esc_html__( 'Regular Price', 'woocommerce-advbulkedit');
		if($arr['_regular_price'] === "Regular Price")
			$arr['_regular_price'] = esc_html__( 'Regular Price', 'woocommerce');
		$arr['_sale_price'] = esc_html__( 'Sale Price', 'woocommerce-advbulkedit');
		if($arr['_sale_price'] === "Sale Price")
			$arr['_sale_price'] = esc_html__( 'Sale Price', 'woocommerce');
		$arr['_default_attributes'] = esc_html__( 'Default Attributes', 'woocommerce-advbulkedit');
		if($arr['_default_attributes'] === "Default Attributes")
			$arr['_default_attributes'] = esc_html__( 'Default', 'woocommerce').' '.esc_html__( 'Attributes', 'woocommerce');
		$arr['product_type'] = esc_html__( 'Product Type', 'woocommerce-advbulkedit');
		if($arr['product_type'] === "Product Type")
			$arr['product_type'] = esc_html__( 'Product Type', 'woocommerce');
		$arr['menu_order'] = esc_html__( 'Menu order', 'woocommerce-advbulkedit');
		if($arr['menu_order'] === "Menu order")
			$arr['menu_order'] = esc_html__( 'Menu order', 'woocommerce');
		$arr['comment_status'] = esc_html__( 'Enable reviews', 'woocommerce-advbulkedit');
		if($arr['comment_status'] === "Enable reviews")
			$arr['comment_status'] = esc_html__( 'Enable reviews', 'woocommerce');
		$arr['_button_text'] = esc_html__( 'Button text', 'woocommerce-advbulkedit');
		if($arr['_button_text'] === "Button text")
			$arr['_button_text'] = esc_html__( 'Button text', 'woocommerce');
		$arr['_product_url'] = esc_html__( 'Product URL', 'woocommerce-advbulkedit');
		if($arr['_product_url'] === "Product URL")
			$arr['_product_url'] = esc_html__( 'Product URL', 'woocommerce');
		$arr['_download_type'] = esc_html__( 'Download Type', 'woocommerce-advbulkedit');
		if($arr['_download_type'] === "Download Type")
			$arr['_download_type'] = esc_html__( 'Download Type', 'woocommerce');
		$arr['_downloadable_files'] = esc_html__( 'Downloadable Files', 'woocommerce-advbulkedit');
		if($arr['_downloadable_files'] === "Downloadable Files")
			$arr['_downloadable_files'] = esc_html__( 'Downloadable Files', 'woocommerce');
		$arr['_download_limit'] = esc_html__( 'Download Limit', 'woocommerce-advbulkedit');
		if($arr['_download_limit'] === "Download Limit")
			$arr['_download_limit'] = esc_html__( 'Download Limit', 'woocommerce');
		$arr['_download_expiry'] = esc_html__( 'Download Expiry', 'woocommerce-advbulkedit');
		if($arr['_download_expiry'] === "Download Expiry")
			$arr['_download_expiry'] = esc_html__( 'Download Expiry', 'woocommerce');
		$arr['_virtual'] = esc_html__( 'Virtual', 'woocommerce-advbulkedit');
		if($arr['_virtual'] === "Virtual")
			$arr['_virtual'] = esc_html__( 'Virtual', 'woocommerce');
		$arr['_downloadable'] = esc_html__( 'Downloadable', 'woocommerce-advbulkedit');
		if($arr['_downloadable'] === "Downloadable")
			$arr['_downloadable'] = esc_html__( 'Downloadable', 'woocommerce');
		$arr['_crosssell_ids'] = esc_html__( 'Cross-Sells', 'woocommerce-advbulkedit');
		if($arr['_crosssell_ids'] === "Cross-Sells")
			$arr['_crosssell_ids'] = esc_html__( 'Cross-Sells', 'woocommerce');
		$arr['_upsell_ids'] = esc_html__( 'Up-Sells', 'woocommerce-advbulkedit');
		if($arr['_upsell_ids'] === "Up-Sells")
			$arr['_upsell_ids'] = esc_html__( 'Up-Sells', 'woocommerce');
		$arr['_visibility'] = esc_html__( 'Catalog visibility:', 'woocommerce-advbulkedit');
		if($arr['_visibility'] === "Catalog visibility:")
			$arr['_visibility'] = esc_html__( 'Catalog visibility:', 'woocommerce');
		$arr['post_status'] = esc_html__( 'Status', 'woocommerce-advbulkedit');
		if($arr['post_status'] === "Status")
			$arr['post_status'] = esc_html__( 'Status', 'woocommerce');
		$arr['_purchase_note'] = esc_html__( 'Purchase Note', 'woocommerce-advbulkedit');
		if($arr['_purchase_note'] === "Purchase Note")
			$arr['_purchase_note'] = esc_html__( 'Purchase Note', 'woocommerce');
		$arr['product_shipping_class'] = esc_html__( 'Shipping class', 'woocommerce-advbulkedit');
		if($arr['product_shipping_class'] === "Shipping class")
			$arr['product_shipping_class'] = esc_html__( 'Shipping class', 'woocommerce');
		$arr['grouped_items'] = esc_html__( 'Grouping', 'woocommerce-advbulkedit');
		if($arr['grouped_items'] === "Grouping")
			$arr['grouped_items'] = esc_html__( 'Grouping', 'woocommerce');
		$arr['_sold_individually'] = esc_html__( 'Sold Individually', 'woocommerce-advbulkedit');
		if($arr['_sold_individually'] === "Sold Individually")
			$arr['_sold_individually'] = esc_html__( 'Sold Individually', 'woocommerce');
		$arr['_backorders'] = esc_html__( 'Allow Backorders?', 'woocommerce-advbulkedit');
		if($arr['_backorders'] === "Allow Backorders?")
			$arr['_backorders'] = esc_html__( 'Allow Backorders?', 'woocommerce');
		$arr['_manage_stock'] = esc_html__( 'Manage Stock', 'woocommerce-advbulkedit');
		if($arr['_manage_stock'] === "Manage Stock")
			$arr['_manage_stock'] = esc_html__( 'Manage Stock', 'woocommerce');

		$arr['_stock_status'] = esc_html__( 'Stock Status', 'woocommerce-advbulkedit');
		if($arr['_stock_status'] === "Stock Status")
			$arr['_stock_status'] = esc_html__( 'Stock Status', 'woocommerce');
		$arr['_stock'] = esc_html__( 'Stock Qty', 'woocommerce-advbulkedit');
		if($arr['_stock'] === "Stock Qty")
			$arr['_stock'] = esc_html__( 'Stock Qty', 'woocommerce');
		$arr['_length'] = esc_html__( 'Length', 'woocommerce-advbulkedit');
		if($arr['_length'] === "Length")
			$arr['_length'] = esc_html__( 'Length', 'woocommerce');
		$arr['_sale_price_dates_to'] = esc_html__( 'Sale end date:', 'woocommerce-advbulkedit');
		if($arr['_sale_price_dates_to'] === "Sale end date:")
			$arr['_sale_price_dates_to'] = esc_html__( 'Sale end date:', 'woocommerce');
		$arr['_sale_price_dates_from'] = esc_html__( 'Sale start date:', 'woocommerce-advbulkedit');
		if($arr['_sale_price_dates_from'] === "Sale start date:")
			$arr['_sale_price_dates_from'] = esc_html__( 'Sale start date:', 'woocommerce');
		$arr['_tax_class'] = esc_html__( 'Tax class', 'woocommerce-advbulkedit');
		if($arr['_tax_class'] === "Tax class")
			$arr['_tax_class'] = esc_html__( 'Tax class', 'woocommerce');
		$arr['_tax_status'] = esc_html__( 'Tax Status', 'woocommerce-advbulkedit');
		if($arr['_tax_status'] === "Tax Status")
			$arr['_tax_status'] = esc_html__( 'Tax Status', 'woocommerce');
		$arr['_featured'] = esc_html__( 'Featured', 'woocommerce-advbulkedit');
		if($arr['_featured'] === "Featured")
			$arr['_featured'] = esc_html__( 'Featured', 'woocommerce');
		$arr['_width'] = esc_html__( 'Width', 'woocommerce-advbulkedit');
		if($arr['_width'] === "Width")
			$arr['_width'] = esc_html__( 'Width', 'woocommerce');
		$arr['_height'] = esc_html__( 'Height', 'woocommerce-advbulkedit');
		if($arr['_height'] === "Height")
			$arr['_height'] = esc_html__( 'Height', 'woocommerce');
		$arr['_weight'] = esc_html__( 'Weight', 'woocommerce-advbulkedit');
		if($arr['_weight'] === "Weight")
			$arr['_weight'] = esc_html__( 'Weight', 'woocommerce');
		$arr['post_date'] = esc_html__( 'Publish Date', 'woocommerce-advbulkedit');
		if($arr['post_date'] === "Publish Date")
			$arr['post_date'] = esc_html__( 'Publish Date', 'woocommerce');
		$arr['post_author'] = esc_html__( 'Post Author', 'woocommerce-advbulkedit');
		if($arr['post_author'] === "Post Author")
			$arr['post_author'] = esc_html__( 'Post Author', 'woocommerce');
		$arr['post_type'] = esc_html__( 'Post Type', 'woocommerce-advbulkedit');
		$arr['_variation_description'] = esc_html__( 'Variation Description', 'woocommerce-advbulkedit');
		$arr['_custom_attributes'] = esc_html__( 'Custom Attributes', 'woocommerce-advbulkedit');
		$arr['trans_data_placeholder'] = esc_html__( 'choose\search', 'woocommerce-advbulkedit');
		$arr['trans_column_settings'] = esc_html__( 'Column Settings', 'woocommerce-advbulkedit');
		$arr['trans_table_views'] = esc_html__( 'Table Views', 'woocommerce-advbulkedit');
		$arr['trans_custom_fields'] = esc_html__( 'Custom Fields', 'woocommerce-advbulkedit');
		$arr['trans_find_custom_fields'] = esc_html__( 'Find Custom / Meta Fields', 'woocommerce-advbulkedit');
		$arr['trans_plugin_settings'] = esc_html__( 'Plugin Settings', 'woocommerce-advbulkedit');
		$arr['trans_main_settings'] = esc_html__( 'Main Settings', 'woocommerce-advbulkedit');
		$arr['trans_search_settings'] = esc_html__( 'Search Fields', 'woocommerce-advbulkedit');
		$arr['trans_collapse_filters'] = esc_html__( 'Collapse Filters -', 'woocommerce-advbulkedit');
		$arr['trans_expand_filters'] = esc_html__( 'Expand Filters +', 'woocommerce-advbulkedit');
		$arr['trans_images_hover'] = esc_html__( 'Show larger images on hover', 'woocommerce-advbulkedit');
		$arr['trans_straight_edit'] = esc_html__( 'Clicking on image goes straight to edit', 'woocommerce-advbulkedit');
		$arr['trans_remove_name'] = esc_html__( 'remove name', 'woocommerce-advbulkedit');
		$arr['trans_remove_value'] = esc_html__( 'remove value', 'woocommerce-advbulkedit');
		$arr['trans_sell_status'] = esc_html__( 'To change table view you need to save/revert changes first', 'woocommerce-advbulkedit');
		$arr['trans_selected_text'] = esc_html__( "Selected rows for bulk editing", "woocommerce-advbulkedit");
		$arr['trans_saving_batch'] = esc_html__( "Saving batch", "woocommerce-advbulkedit");
		$arr['trans_show_sell'] = esc_html__( 'Show Selected Only', 'woocommerce-advbulkedit');
		$arr['trans_show_all'] = esc_html__( 'Show All', 'woocommerce-advbulkedit');
		$arr['trans_linkallvars'] =  esc_html__( 'Link all variations', 'woocommerce-advbulkedit');
		$arr['trans_skipduplicates'] =  esc_html__( 'Skip duplicate variations on creation', 'woocommerce-advbulkedit');
		$arr['trans_copyparentprice'] =  esc_html__( 'Copy prices from parent', 'woocommerce-advbulkedit');
		$arr['trans_use_builtin'] =  esc_html__( 'Use built-in editor when editing descriptions', 'woocommerce-advbulkedit');
		$arr['trans_bulk_edit_selected'] =  esc_html__( 'Advanced Bulk Editing of Selected Products', 'woocommerce-advbulkedit');
		$arr['trans_instock'] = esc_html__( 'In Stock', 'woocommerce-advbulkedit');
		if($arr['trans_instock'] === "In Stock")
			$arr['trans_instock'] = esc_html__( 'In Stock', 'woocommerce');
		$arr['trans_outofstock'] = esc_html__( 'Out of stock', 'woocommerce-advbulkedit');
		if($arr['trans_outofstock'] === "Out of stock")
			$arr['trans_outofstock'] = esc_html__( 'Out of stock', 'woocommerce');
		// Hints translations
		$arr['trans_hint_filter_id'] = wp_kses(__(
			'The \"filter expression\" option enables filtering using an advanced expression that allows specifying a ' .
			'mix of IDs and range of IDs. For example:<br /><br />' .
			'234,345,450-576,800,900-1005<br /><br />' .
			'This will filter IDs 234,345 and 800 and also the range of IDs between 450 and 576 and the range ' .
			'of IDs between 900 and 1005. The range includes the limiting values, e.g. 450 and 576.', 'woocommerce-advbulkedit'), ['br' => []]);
		$arr['split_variations_select_variations'] = esc_html__('You have to select some variations, prior to spliiting it.', 'woocommerce-advbulkedit');
		$arr['split_variations_dialog_title'] = esc_html__('Split Variations to Simple Products', 'woocommerce-advbulkedit');

	}

	public function showMainPage()
	{
		global $wpdb;
		global $woocommerce;

		$settings = get_option('w3exabe_settings');

        if (isset($_GET['setting_disable_hints']) && $_GET['setting_disable_hints'] == 1) {
	        $settings['setting_disable_hints'] = 1;
	        update_option('w3exabe_settings',$settings);
        }


		if (isset($_GET['setting_enable_admin_only_visible']) && $_GET['setting_enable_admin_only_visible'] == 1) {
			$settings['setting_enable_admin_only_visible'] = 1;
			update_option('w3exabe_settings',$settings);
		}

		if (isset($_GET['setting_display_top_bar_link_bulkedit']) && $_GET['setting_display_top_bar_link_bulkedit'] == 1) {
			$settings['setting_display_top_bar_link_bulkedit'] = 1;
			update_option('w3exabe_settings',$settings);
		}

		if (isset($_GET['setting_set_time_limit_for_ajax_requests']) && $_GET['setting_set_time_limit_for_ajax_requests'] == 1) {
			$settings['setting_set_time_limit_for_ajax_requests'] = 1;
			update_option('w3exabe_settings',$settings);
		}

		//
		$skiploadfrontpage = true;
		if(isset($woocommerce) && property_exists($woocommerce,'version'))
		{
			$version = (double)$woocommerce->version;
			if($version > 2.6)
				$this->isversion3 = true;
		}
		if(function_exists('icl_object_id') || has_filter('wpml_object_id'))
		{
			if(ICL_LANGUAGE_CODE != 'all')
			{
				$this->iswpml = true;
			}

		}
		$this->loadAttributes($skiploadfrontpage);
		$sel_fields = get_option('w3exabe_columns');
		if (file_exists( __DIR__.'/integrations/show-hide-fields-personalization-per-user.php')) {
		    require_once('integrations/show-hide-fields-personalization-per-user.php');
			$sel_fields = W3ExABulkEdit_Integ_ShowHideFieldsPerUser::getColumnsPerUserOption('w3exabe_columns');
        }
		$purl = plugin_dir_url(__FILE__);

		if(is_rtl())
		{
			echo '<style>
					.w3exabe input,textarea {
						direction: rtl !important;
					}
					.w3exabe div.slick-cell {
						direction: rtl !important;
					}
				</style>';
		}
		echo "<script>
		var W3Ex = W3Ex || {};
		W3Ex.attributes =  {};
		W3Ex.attributes_mapped =  {};
		W3Ex.attributes_slugs_mapped =  {};
		W3Ex.attr_cols =  {};
		W3Ex.categories =  [];
		W3Ex._translate_strings = {};
		W3Ex._global_settings = {};
		W3Ex.imagepath = '".plugin_dir_url(__FILE__)."';";
		if(is_rtl())
		{
			echo PHP_EOL;
			echo 'W3Ex._isrtlenabled = true;';
		}
		if(function_exists('icl_object_id') || has_filter('wpml_object_id'))
		{
			if(ICL_LANGUAGE_CODE != 'all')
			{
				echo PHP_EOL;
				echo 'W3Ex._iswpmlenabled = 1;';

			}

		}
		echo PHP_EOL;
		if($this->isversion3 )
		{
			echo 'W3Ex._isversion3 = 1;';
			echo PHP_EOL;
		}
		if(isset($woocommerce) && property_exists($woocommerce,'version'))
		{
			$version = (double)$woocommerce->version;
			if($version > 2.6)
			{

				echo 'W3Ex._wooversion = '.$version.';';
				echo PHP_EOL;
			}
		}
		$upload_dir = wp_upload_dir();
		if(is_array($upload_dir) && isset($upload_dir['baseurl']))
		{
			$upload_dir = trim($upload_dir['baseurl']);
			echo 'W3Ex.uploaddir = "'. $upload_dir .'";';
		}
		echo PHP_EOL;
		if(defined(WC_DELIMITER))
		{
			echo 'W3Ex._w3ex_wc_delimiter = "'. WC_DELIMITER .'";';
		}else
		{
			echo 'W3Ex._w3ex_wc_delimiter = "|";';
		}
		echo PHP_EOL;
		if($skiploadfrontpage)
		{
			foreach($this->attributes as $attr)
			{
		 		foreach($attr->values as $value)
				{
					$attrname = str_replace("\n", '\n', str_replace('"', '\"', addcslashes(str_replace("\r", '', (string)$attr->name), "\0..\37'\\")));
					$attrname = trim(preg_replace('/\s+/', ' ', $attrname));
					$attrslug = $value->slug;
					$attrslug = trim(preg_replace('/\s+/', ' ', $attrslug));
					$attrvalname = str_replace("\n", '\n', str_replace('"', '\"', addcslashes(str_replace("\r", '', (string)$value->name), "\0..\37'\\")));
					$attrvalname = trim(preg_replace('/\s+/', ' ', $attrvalname));
					echo 'W3Ex.attributes['.$value->id.'] = {id:'.$value->id.',term_id:'.$value->term_id.',name:"'.$attrvalname.'",attr:"'.$attrname.'",value:"'.$attrslug.'"};';
					echo PHP_EOL;
					echo 'W3Ex.attributes_mapped['.$value->term_id.'] = '.$value->id.';';
					echo PHP_EOL;
					echo 'W3Ex.attributes_slugs_mapped["'.$value->slug.$attr->name.'"] = '.$value->id.';';
					echo PHP_EOL;
				}
			}
		}
		foreach($this->attributes as $attr)
		{
			$attrname = $attr->name;
			$attrname = trim(preg_replace('/\s+/', ' ', $attrname));
			$attrlabel = str_replace("\n", '\n', str_replace('"', '\"', addcslashes(str_replace("\r", '', (string)$attr->label), "\0..\37'\\")));
			$attrlabel = trim(preg_replace('/\s+/', ' ', $attrlabel));
			echo 'W3Ex.attr_cols["'.$attrname.'"] = {id:'.$attr->id.',attr:"'.$attrlabel.'",value:"'.$attrname.'"};';
			echo PHP_EOL;
		}
		$blogusers = get_users(['fields' => array( 'ID', 'display_name' )]);
		$settings = get_option('w3exabe_settings');
		if(!is_array($settings))
			$settings = array();
		if(is_array($sel_fields) && !empty($sel_fields))
		{
			echo 'W3Ex.colsettings = '. json_encode($sel_fields). ';';
		    echo PHP_EOL;
		}
		$sel_fields = get_option('w3exabe_views');
		if(is_array($sel_fields) && !empty($sel_fields))
		{
			echo 'W3Ex.w3exabe_listviews = '. json_encode($sel_fields). ';';
		    echo PHP_EOL;
		}
		$sel_fields = get_option('w3exabe_customsel');
		if(is_array($sel_fields) && !empty($sel_fields))
		{
			echo 'W3Ex.customfieldssel = '. json_encode($sel_fields). ';';
		    echo PHP_EOL;
		}

		$sel_fields = get_option('w3exabe_custom');
		if(is_array($sel_fields) && !empty($sel_fields))
		{
			echo 'W3Ex.customfields = '. json_encode($sel_fields). ';';
		    echo PHP_EOL;
		}
		$tax_classes = WC_Tax::get_tax_classes();
        if (count($tax_classes) > 0)
		{
			$classtring = "Standard";
			foreach($tax_classes as $class)
			{
				$classtring.= ','.$class;
			}
			echo 'W3Ex._tax_class_values = "'.$classtring.'";'; echo PHP_EOL;
		}
		if (wcabe_load_integration(WCABE_187_INTEG_LIMIT_SHOP_MANAGER_VIEW)) {
			W3ExABulkEdit_Integ_LimitShopManagerView::add_js_integ_enable();
		}

				if(isset($settings['tableheight']) && is_numeric($settings['tableheight']))
				{
					echo 'W3Ex._w3esetting_table_height = "'.$settings['tableheight'].'";'; echo PHP_EOL;
				}
				else {
					$default_table_height = "650";
					echo 'W3Ex._w3esetting_table_height = "'.$default_table_height.'";'; echo PHP_EOL;
					$settings['tableheight'] = "650";
					update_option('w3exabe_settings',$settings);
				}
				if(isset($settings['disablesafety']) && is_numeric($settings['disablesafety']))
				{
					if($settings['disablesafety'] == 1)
					 echo 'W3Ex._w3esetting_disablesafety = true;'; echo PHP_EOL;
				}
				if(isset($settings['showthumbnails']))
				{
					if($settings['showthumbnails'] == 1)
					 	echo 'W3Ex._global_settings["showthumbnails"] = true;'; echo PHP_EOL;
				}
				if(isset($settings['openimage']))
				{
					if($settings['openimage'] == 1)
					 	echo 'W3Ex._global_settings["openimage"] = true;'; echo PHP_EOL;
				}
				if(isset($settings['usebuiltineditor']))
				{
					if($settings['usebuiltineditor'] == 1)
					 	echo 'W3Ex._global_settings["usebuiltineditor"] = true;'; echo PHP_EOL;
				}
				if(isset($settings['filterstate']))
				{
					if($settings['filterstate'] == 1)
					 	echo 'W3Ex._global_settings["filterstate"] = true;'; echo PHP_EOL;
				}
				if(isset($settings['savebatch']) && is_numeric($settings['savebatch']))
				{
					echo 'W3Ex._global_settings["savebatch"] = "'.$settings['savebatch'].'";'; echo PHP_EOL;
				}
				if(isset($settings['treattagsastext']) && $settings['treattagsastext'] == 1)
				{
					echo 'W3Ex._global_settings["treattagsastext"] = "1";'; echo PHP_EOL;
				}
			if ( is_plugin_active( 'woocommerce-cost-of-goods/woocommerce-cost-of-goods.php' ) )
			{
			    $settings['iswoocostog'] = 1;
			    update_option('w3exabe_settings',$settings);
			}else
			{
				if(isset($settings['iswoocostog']) && $settings['iswoocostog'] == 1)
				{
					unset($settings['iswoocostog']);
			   		update_option('w3exabe_settings',$settings);
				}
			}
			$arrTranslated = array();
			$this->loadTranslations($arrTranslated);
			echo 'W3Ex._translate_strings["trans_bulk_edit_selected"] = "'.self::relpaceInvalid($arrTranslated['trans_bulk_edit_selected']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_use_builtin"] = "'.self::relpaceInvalid($arrTranslated['trans_use_builtin']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_linkallvars"] = "'.self::relpaceInvalid($arrTranslated['trans_linkallvars']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_skipduplicates"] = "'.self::relpaceInvalid($arrTranslated['trans_skipduplicates']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_copyparentprice"] = "'.self::relpaceInvalid($arrTranslated['trans_copyparentprice']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_column_settings"] = "'.self::relpaceInvalid($arrTranslated['trans_column_settings']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_selected_text"] = "'.self::relpaceInvalid($arrTranslated['trans_selected_text']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_saving_batch"] = "'.self::relpaceInvalid($arrTranslated['trans_saving_batch']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_table_views"] = "'.self::relpaceInvalid($arrTranslated['trans_table_views']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_custom_fields"] = "'.self::relpaceInvalid($arrTranslated['trans_custom_fields']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_find_custom_fields"] = "'.self::relpaceInvalid($arrTranslated['trans_find_custom_fields']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_plugin_settings"] = "'.self::relpaceInvalid($arrTranslated['trans_plugin_settings']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_collapse_filters"] = "'.self::relpaceInvalid($arrTranslated['trans_collapse_filters']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_expand_filters"] = "'.self::relpaceInvalid($arrTranslated['trans_expand_filters']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_images_hover"] = "'.self::relpaceInvalid($arrTranslated['trans_images_hover']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_straight_edit"] = "'.self::relpaceInvalid($arrTranslated['trans_straight_edit']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_data_placeholder"] = "'.self::relpaceInvalid($arrTranslated['trans_data_placeholder']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_sell_status"] = "'.self::relpaceInvalid($arrTranslated['trans_sell_status']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_show_sell"] = "'.self::relpaceInvalid($arrTranslated['trans_show_sell']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_show_all"] = "'.self::relpaceInvalid($arrTranslated['trans_show_all']).'";'; echo PHP_EOL;
			echo 'W3Ex._translate_strings["trans_hint_filter_id"] = "'.$arrTranslated['trans_hint_filter_id'].'";'; echo PHP_EOL;
			echo 'W3Ex.post_excerpt = "'. self::relpaceInvalid($arrTranslated['post_excerpt']).'";'; echo PHP_EOL;
			echo 'W3Ex.post_content = "'.self::relpaceInvalid($arrTranslated['post_content']).'";'; echo PHP_EOL;
			echo 'W3Ex._thumbnail_id = "'.self::relpaceInvalid($arrTranslated['_thumbnail_id']).'";'; echo PHP_EOL;
			echo 'W3Ex._product_image_gallery = "'.self::relpaceInvalid($arrTranslated['_product_image_gallery']).'";'; echo PHP_EOL;
			echo 'W3Ex._sku = "'.self::relpaceInvalid($arrTranslated['_sku']).'";'; echo PHP_EOL;
			echo 'W3Ex.post_name = "'.self::relpaceInvalid($arrTranslated['post_name']).'";'; echo PHP_EOL;
			echo 'W3Ex.product_tag = "'.self::relpaceInvalid($arrTranslated['product_tag']).'";'; echo PHP_EOL;
			echo 'W3Ex._virtual = "'.self::relpaceInvalid($arrTranslated['_virtual']).'";'; echo PHP_EOL;
			echo 'W3Ex._downloadable = "'.self::relpaceInvalid($arrTranslated['_downloadable']).'";'; echo PHP_EOL;
			echo 'W3Ex.instock = "'.self::relpaceInvalid(esc_html__( 'In stock', 'woocommerce')).'";'; echo PHP_EOL;
			echo 'W3Ex.outofstock = "'.self::relpaceInvalid(esc_html__( 'Out of stock', 'woocommerce')).'";'; echo PHP_EOL;
			echo 'W3Ex.post_title = "'.self::relpaceInvalid($arrTranslated['post_title']).'";'; echo PHP_EOL;
			echo 'W3Ex.product_cat = "'.self::relpaceInvalid($arrTranslated['product_cat']).'";'; echo PHP_EOL;
			echo 'W3Ex._regular_price = "'.self::relpaceInvalid($arrTranslated['_regular_price']).'";'; echo PHP_EOL;
			echo 'W3Ex._sale_price = "'.self::relpaceInvalid($arrTranslated['_sale_price']).'";'; echo PHP_EOL;
			echo 'W3Ex._sale_price_dates_from = "'.self::relpaceInvalid($arrTranslated['_sale_price_dates_from']).'";'; echo PHP_EOL;
			echo 'W3Ex._sale_price_dates_to = "'.self::relpaceInvalid($arrTranslated['_sale_price_dates_to']).'";'; echo PHP_EOL;
			echo 'W3Ex._featured = "'.self::relpaceInvalid($arrTranslated['_featured']).'";'; echo PHP_EOL;
			echo 'W3Ex._tax_status = "'.self::relpaceInvalid($arrTranslated['_tax_status']).'";'; echo PHP_EOL;
			echo 'W3Ex._tax_class = "'.self::relpaceInvalid($arrTranslated['_tax_class']).'";'; echo PHP_EOL;
			echo 'W3Ex._weight = "'.self::relpaceInvalid($arrTranslated['_weight']).'";'; echo PHP_EOL;
			echo 'W3Ex._height = "'.self::relpaceInvalid($arrTranslated['_height']).'";'; echo PHP_EOL;
			echo 'W3Ex._width = "'.self::relpaceInvalid($arrTranslated['_width']).'";'; echo PHP_EOL;
			echo 'W3Ex._length = "'.self::relpaceInvalid($arrTranslated['_length']).'";'; echo PHP_EOL;
			echo 'W3Ex._stock = "'.self::relpaceInvalid($arrTranslated['_stock']).'";'; echo PHP_EOL;
			echo 'W3Ex._stock_status  = "'.self::relpaceInvalid($arrTranslated['_stock_status']).'";'; echo PHP_EOL;
			echo 'W3Ex._manage_stock = "'.self::relpaceInvalid($arrTranslated['_manage_stock']).'";'; echo PHP_EOL;
			echo 'W3Ex._backorders = "'.self::relpaceInvalid($arrTranslated['_backorders']).'";'; echo PHP_EOL;
			echo 'W3Ex._sold_individually = "'.self::relpaceInvalid($arrTranslated['_sold_individually']).'";'; echo PHP_EOL;
			echo 'W3Ex.product_shipping_class = "'.self::relpaceInvalid($arrTranslated['product_shipping_class']).'";'; echo PHP_EOL;
			echo 'W3Ex._purchase_note = "'.self::relpaceInvalid($arrTranslated['_purchase_note']).'";'; echo PHP_EOL;
			echo 'W3Ex.post_status = "'.self::relpaceInvalid($arrTranslated['post_status']).'";'; echo PHP_EOL;
			echo 'W3Ex._visibility = "'.self::relpaceInvalid($arrTranslated['_visibility']).'";'; echo PHP_EOL;
			echo 'W3Ex._upsell_ids = "'.self::relpaceInvalid($arrTranslated['_upsell_ids']).'";'; echo PHP_EOL;
			echo 'W3Ex._crosssell_ids = "'.self::relpaceInvalid($arrTranslated['_crosssell_ids']).'";'; echo PHP_EOL;
			echo 'W3Ex._downloadable = "'.self::relpaceInvalid($arrTranslated['_downloadable']).'";'; echo PHP_EOL;
			echo 'W3Ex._virtual = "'.self::relpaceInvalid($arrTranslated['_virtual']).'";'; echo PHP_EOL;
			echo 'W3Ex._download_expiry = "'.self::relpaceInvalid($arrTranslated['_download_expiry']).'";'; echo PHP_EOL;
			echo 'W3Ex._download_limit = "'.self::relpaceInvalid($arrTranslated['_download_limit']).'";'; echo PHP_EOL;
			echo 'W3Ex._downloadable_files = "'.self::relpaceInvalid($arrTranslated['_downloadable_files']).'";'; echo PHP_EOL;
			echo 'W3Ex._download_type = "'.self::relpaceInvalid($arrTranslated['_download_type']).'";'; echo PHP_EOL;
			echo 'W3Ex._product_url = "'.self::relpaceInvalid($arrTranslated['_product_url']).'";'; echo PHP_EOL;
			echo 'W3Ex._button_text = "'.self::relpaceInvalid($arrTranslated['_button_text']).'";'; echo PHP_EOL;
			echo 'W3Ex.comment_status = "'.self::relpaceInvalid($arrTranslated['comment_status']).'";'; echo PHP_EOL;
			echo 'W3Ex.menu_order = "'.self::relpaceInvalid($arrTranslated['menu_order']).'";'; echo PHP_EOL;
			echo 'W3Ex.product_type = "'.self::relpaceInvalid($arrTranslated['product_type']).'";'; echo PHP_EOL;
			echo 'W3Ex._default_attributes = "'.self::relpaceInvalid($arrTranslated['_default_attributes']).'";'; echo PHP_EOL;
			echo 'W3Ex.grouped_items = "'.self::relpaceInvalid($arrTranslated['grouped_items']).'";'; echo PHP_EOL;
			echo 'W3Ex.post_date = "'.self::relpaceInvalid($arrTranslated['post_date']).'";'; echo PHP_EOL;
			echo 'W3Ex._custom_attributes = "'.self::relpaceInvalid($arrTranslated['_custom_attributes']).'";'; echo PHP_EOL;
			echo 'W3Ex._variation_description = "'.self::relpaceInvalid($arrTranslated['_variation_description']).'";'; echo PHP_EOL;
			echo 'W3Ex.split_variations_dialog_title = "'.self::relpaceInvalid($arrTranslated['split_variations_dialog_title']).'";'; echo PHP_EOL;
			echo 'W3Ex.split_variations_select_variations = "'.self::relpaceInvalid($arrTranslated['split_variations_select_variations']).'";'; echo PHP_EOL;
		echo "</script>";
		?>
		<script type="text/javascript">
                   if(jQuery.fn.select2 === undefined)
                   {
				   	   jQuery.fn.extend({
						    select2: function () {
						    	//dummy function to prevent code from morons
								return;
						    }
						});
				   }

         </script>

		<div class="wrap w3exabe">
		<a id="backlink" href="#">&lt; Back</a>
		<div class="infomessage">
			<div class="background">
			    <div class="content">
			        <p>
			        	Duplicate SKU(s) detected.
			        </p>
			    </div>
			</div>
			<span class="icon"></span>
		</div>
		<h2>
			<?php esc_html_e( 'WooCommerce Advanced Bulk Edit', 'woocommerce-advbulkedit');?>
			<span class="version">(v<?php echo WCABE_VERSION; ?>)</span>
			<span class="top-help-links">
				<a href="https://wpmelon.com/r/wcabe-getting-started" target="_blank">Getting Started tutorial</a>
					&nbsp;&nbsp;&nbsp;
				<a href="https://wpmelon.com/r/whats-new" target="_blank">What's New</a>
					&nbsp;&nbsp;
				<a href="https://wpmelon.com/r/support" target="_blank">Get Support</a>
					&nbsp;&nbsp;
				<a href="<?php echo home_url().'/wp-admin/edit.php?post_type=product&page=advanced_bulk_edit&section=wcabe_settings'; ?>">Add License</a>
			</span>
		</h2>
		<?php
		if (wcabe_load_integration(WCABE_179_INTEG_SITE_WIDE_OPS)) {
			W3ExABulkEdit_Integ_SiteWideOps::site_wide_ops_the_link();
		}
		?>
		<br/>
			<div id="frontpageinfoholder" style="position:relative;"></div>
      <?php
        if (WCABE_E_R) {
	        delete_transient( W3ExAdvancedBulkEditMain::$cache_key );
      ?>
			<div class="notice notice-info is-dismissible">
        <p>
            <?php esc_html_e("Please, update WooCommerce Advanced Bulk Edit from WordPress > ", 'woocommerce-advbulkedit'); ?>
            <a href="<?php echo admin_url('plugins.php'); ?>"><?php esc_html_e('Plugins', 'woocommerce-advbulkedit'); ?></a>
	          <?php esc_html_e(" section.", 'woocommerce-advbulkedit'); ?>
        </p>
        <p><?php esc_html_e('For more info', 'woocommerce-advbulkedit'); ?> <a href="<?php echo WCABE_UPDATE_INFO_URL; ?>" target="_blank"><?php esc_html_e('read here', 'woocommerce-advbulkedit'); ?></a></p>
      </div>
      <?php } ?>
			<div class="notice notice-warning is-dismissible js_issue_notice">
						<p>
							<?php esc_html_e('Checking for JS issues... ', 'woocommerce-advbulkedit'); ?>
              <span id="wcabe-checking-js-issues-result" style="visibility: hidden"><?php esc_html_e('none detected!', 'woocommerce-advbulkedit'); ?></span>
						</p>
            <p id="wcabe-checking-js-issues-help-info">
	            <?php esc_html_e("If this message doesn't hide", 'woocommerce-advbulkedit'); ?>, you can <a href="<?php echo WCABE_SUPPORT_URL; ?>" target="_blank"><?php esc_html_e('contact our support team', 'woocommerce-advbulkedit'); ?></a><?php esc_html_e(' for assistance in resolving the problem.', 'woocommerce-advbulkedit'); ?>
              <a href="<?php echo WCABE_SUPPORT_JS_NOTICE_MORE_INFO_URL; ?>" target="_blank"><?php esc_html_e('More info', 'woocommerce-advbulkedit'); ?></a>
            </p>
			</div>
			<br />

			<button id="collapsefilters" class="button-wcabe" data-state="collapse"><?php esc_html_e( 'Collapse Filters -', 'woocommerce-advbulkedit');?></button>
			<input id="searchfilters" type="search" style="width:150px;" placeholder="<?php esc_html_e('search filters', 'woocommerce-advbulkedit');?>"></input>
            <button class="btn-info" id="btn-info-filters-section"></button>
            <template id="btn-info-filters-section-body">
                <?php echo wp_kses(__('You can enable/disable filters from:<br>"Plugin Settings" > "Search Fields"', 'woocommerce-advbulkedit'), ['br' => []]); ?>
            </template>
			<table cellpadding="5" cellspacing="0" id="tablesearchfilters" style="">
			<tbody>
			<tr>
			<td>
			<?php echo $arrTranslated['post_title']; ?>: </td>
			<td data-id="post_title">
			<select id="titleparams">
				<option value="con"><?php esc_html_e( 'contains', 'woocommerce-advbulkedit');?></option>
				<option value="isexactly"><?php esc_html_e( 'is exactly', 'woocommerce-advbulkedit');?></option>
				<option value="notcon"><?php esc_html_e( 'does not contain', 'woocommerce-advbulkedit');?></option>
				<option value="start"><?php esc_html_e( 'starts with', 'woocommerce-advbulkedit');?></option>
				<option value="end"><?php esc_html_e( 'ends with', 'woocommerce-advbulkedit');?></option>
			</select>
			<input id="titlevalue" type="text" class="showorcheckbox"/>
			</td>
			<td><?php echo $arrTranslated['product_cat']; ?>: </td>
			<td><select id="selcategory" class="makechosen catsel" data-placeholder="<?php echo $arrTranslated['trans_data_placeholder']; ?>" multiple style="width:250px;">
			 <option value=""></option>
			<?php
				$cats = $this->categories;
				if (file_exists( __DIR__.'/integrations/catnames-to-ids.php')) {
					foreach ($cats as $catInfo) {
						if (isset($catInfo->category_id) && isset($catInfo->category_name)) {
							$catInfo->category_name = $catInfo->category_id;
						}
					}
                }
				$newcats = array();
				$cats_asoc = $this->cat_asoc;
				$depth = array();

			    foreach($cats as $cat)
				{
					if(!isset($cat->category_parent))
					{
						$cat->category_parent = 0;
					}
					$cat->category_parent = (int)$cat->category_parent;
					if($cat->category_parent == 0)
					{
						$depth[$cat->term_id] = 0;
						$newcats[] = $cat;
					}
				}
				foreach($cats as $cat)
				{
					if($cat->category_parent == 0) continue;
					{
						{
							if(!isset($depth[$cat->term_id]))
							{
								$loop = true;
								$counter = 0;
								while($loop && ($counter < 200))
								{
									$counter++;
									foreach($cats as $catin)
									{
										if($catin->category_parent == 0)
										   continue;
										if(isset($depth[$catin->category_parent]))
										{
											$newdepth = $depth[$catin->category_parent];
											$newdepth++;
											if(!isset($depth[$catin->term_id]))
											{
												$depth[$catin->term_id] = $newdepth;
												for($i = 0; $i < count($newcats); $i++)
												{
													$catins = $newcats[$i];
													if($catins->term_id == $catin->category_parent)
													{
														array_splice($newcats, $i+1, 0,array($catin));
														break;
													}
												}
											}

											if($catin->term_id == $cat->term_id)
											{
												$loop = false;
												break;
											}
										}
									}

								}
								if(!isset($depth[$cat->term_id]))
								{
									$depth[$cat->term_id] = 0;
									$newcats[] = $cat;
								}
							}
						}
					}

				}

				if (file_exists( __DIR__.'/integrations/category-filter-display-parent-categories.php')) {
					require_once('integrations/category-filter-display-parent-categories.php');
				}

				if(count($newcats) == count($cats))
				{
					foreach($newcats as $catin)
					{
						$depthstring = '';
						if(isset($depth[$catin->term_id]))
						{
							$depthn = (int)$depth[$catin->term_id];
							if($depthn < 15)
							{
								while($depthn > 0)
								{
									$depthstring = $depthstring.'&nbsp;&nbsp;&nbsp;';
									$depthn--;
								}

							}
						}
						if (class_exists('W3ExABulkEdit_Integ_CategoryFilterDisplayParentCategories')) {
							echo '<option value="'.$catin->category_id.'" >'.
								 W3ExABulkEdit_Integ_CategoryFilterDisplayParentCategories::getCatParents($newcats, $catin).'</option>';
						} else {
							echo '<option value="'.$catin->category_id.'" >'.$depthstring.$catin->category_name.'</option>';
						}

					}
				}else
				{
					foreach($cats as $catin)
					{
						if (class_exists('W3ExABulkEdit_Integ_CategoryFilterDisplayParentCategories')) {
							echo '<option value="'.$catin->category_id.'" >'.
								 W3ExABulkEdit_Integ_CategoryFilterDisplayParentCategories::getCatParents($newcats, $catin).'</option>';
						} else {
							echo '<option value="'.$catin->category_id.'" >'.$catin->category_name.'</option>';
						}

					}
				}

			?>
			</select>&nbsp;<label><input type="checkbox" id="categoryor" style="width:auto;"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></input></label>
			</td></tr>
			<?php
				$endrow = false;
				$counter = 0;
				$settings = get_option('w3exabe_settings');
				$showattrs = "";
				if(is_array($settings))
				{
					if(isset($settings['showattributes']))
					{
						if($settings['showattributes'] == 0)
						{
							$showattrs = 'style="display: none"';
						}
					}
				}
				if(count($this->attributes) > 0)
				{
					foreach($this->attributes as $attr)
					{
						if($counter % 2 == 0)
						{
							echo '<tr class="showattributes" '.$showattrs.'><td>';
						}else
						{
							echo '<td>';
						}
						echo $attr->label.': </td><td><select class="makechosen custattributes" data-placeholder="'.$arrTranslated['trans_data_placeholder'].'" multiple style="width:250px;" data-attrslug="attribute_pa_'.$attr->name.'"> <option value=""></option>';

						foreach($attr->values as $value)
						{
							echo '<option value="'.$value->id.'">'.$value->name.'</option>';
						}
						echo '</select>';
						if($counter % 2 == 0)
						{
							$endrow = false;
							echo '</td>';
						}else
						{
							$endrow = true;
							echo '</td></tr>';
						}
						$counter++;
				    }
					if(!$endrow)
					{
						echo '</tr>';
					}
				}
			?>
			<tr class="showprices"
			<?php
				if(is_array($settings))
				{
					if(isset($settings['showprices']))
					{
						if($settings['showprices'] == 0)
						{
							echo 'style="display: none"';
						}
					}
				}
			?>
			>
				<td><?php echo $arrTranslated['_regular_price']; ?>: </td>
				<td>
				<select id="price">
					<option value="more">></option>
					<option value="less"><</option>
					<option value="equal">==</option>
					<option value="moree">>=</option>
					<option value="lesse"><=</option>
					<option value="compexp">filter expression</option>
				</select>
				<input id="pricevalue" type="text"/>
				<button id="btn-info-filter-regular-price" class="btn-info"></button>
				<template id="btn-info-filter-regular-price-body">
					<?php echo wp_kses(__('The "filter expression" option enables filtering using an advanced expression that allows specifying a mix of individual prices as well as range of prices. For example:<br /><br />', 'woocommerce-advbulkedit'), ['br' => []]); ?>
					<?php echo wp_kses(__('10,20,45-57,80,90-100<br /><br />', 'woocommerce-advbulkedit'), ['br' => []]); ?>
					<?php esc_html_e('This will filter prices 10, 20 and 80 and also the range of prices between 45 and 57 and the ranges of prices between 90 and 100. The range includes the limiting values, e.g. 45 and 57.', 'woocommerce-advbulkedit'); ?>
				</template>
			</td>
				<td><?php echo $arrTranslated['_sale_price']; ?>: </td>
				<td>
				<select id="saleprice">
					<option value="more">></option>
					<option value="less"><</option>
					<option value="equal">==</option>
					<option value="moree">>=</option>
					<option value="lesse"><=</option>
					<option value="compexp">filter expression</option>
				</select>
				<input id="salepricevalue" type="text"/>
					<button id="btn-info-filter-sale-price" class="btn-info"></button>
					<template id="btn-info-filter-sale-price-body">
						<?php echo wp_kses(__('The "filter expression" option enables filtering using an advanced expression that allows specifying a mix of individual prices as well as range of prices. For example:<br /><br />', 'woocommerce-advbulkedit'), ['br' => []]); ?>
						<?php echo wp_kses(__('10,20,45-57,80,90-100<br /><br />', 'woocommerce-advbulkedit'), ['br' => []]); ?>
						<?php esc_html_e('This will filter prices 10, 20 and 80 and also the range of prices between 45 and 57 and the ranges of prices between 90 and 100. The range includes the limiting values, e.g. 45 and 57.', 'woocommerce-advbulkedit'); ?>
					</template>
			</td>
			</tr>
			<tr class="showskutags"
			<?php
				if(is_array($settings))
				{
					if(isset($settings['showskutags']))
					{
						if($settings['showskutags'] == 0)
						{
							echo 'style="display: none"';
						}
					}
				}
			?>
			>
				<td><?php echo $arrTranslated['_sku']; ?>: </td>
				<td>
				<select id="skuparams">
				<option value="con"><?php esc_html_e( 'contains', 'woocommerce-advbulkedit');?></option>
				<option value="isexactly"><?php esc_html_e( 'is exactly', 'woocommerce-advbulkedit');?></option>
				<option value="notcon"><?php esc_html_e( 'does not contain', 'woocommerce-advbulkedit');?></option>
				<option value="start"><?php esc_html_e( 'starts with', 'woocommerce-advbulkedit');?></option>
				<option value="end"><?php esc_html_e( 'ends with', 'woocommerce-advbulkedit');?></option>
			</select>
			<input id="skuvalue" type="text" class="showmultiplecheckbox"/>
			</td>
				<td><?php echo $arrTranslated['product_tag']; ?>: </td>
				<td>
					<select id='tagsparams' class="makechosen paramsvalues" data-placeholder="<?php echo $arrTranslated['trans_data_placeholder']; ?>" multiple style="width:250px;"> <option value=""></option>';
						<?php
						$args = array(
							    'number'     => 99999,
							    'orderby'    => 'slug',
							    'order'      => 'ASC',
							    'hide_empty' => false,
							    'include'    => '',
								'fields'     => 'all'
							);
							$getquery = "SELECT t.name,tt.term_taxonomy_id FROM {$wpdb->prefix}terms as t INNER JOIN {$wpdb->prefix}term_taxonomy AS tt ON t.term_id= tt.term_id WHERE tt.taxonomy IN('product_tag')";
							$woo_tags = $wpdb->get_results($getquery);
							if(!is_wp_error($woo_tags) && is_array($woo_tags))
							{
								foreach($woo_tags as $tag)
								{
									 if(!is_object($tag)) continue;
									 if(!property_exists($tag,'term_taxonomy_id')) continue;
									 if(!property_exists($tag,'name')) continue;
									 if($this->iswpml)
									{
										 if(ICL_LANGUAGE_CODE !== 'all')
										 {
												 $id = self::lang_category_id($tag->term_taxonomy_id,'product_tag');
											 if($id === NULL || $id != $tag->term_taxonomy_id)
													continue;
										 }
										}
									 echo '<option value="'.$tag->term_taxonomy_id.'" >'.$tag->name.'</option>';
								};
							}
						?>
					</select>
				</td>
			</tr>
			<tr class="showdescriptions"
			<?php
				$echovar = 'style="display: none"';
				if(is_array($settings))
				{
					if(isset($settings['showdescriptions']))
					{
						if($settings['showdescriptions'] == 1)
						{
							$echovar = "";
						}
					}
				}
				echo $echovar;
			?>
			>
				<td><?php echo $arrTranslated['post_content']; ?>: </td>
				<td data-id="post_content">
				<select id="descparams">
				<option value="con"><?php esc_html_e( 'contains', 'woocommerce-advbulkedit');?></option>
				<option value="notcon"><?php esc_html_e( 'does not contain', 'woocommerce-advbulkedit');?></option>
				<option value="start"><?php esc_html_e( 'starts with', 'woocommerce-advbulkedit');?></option>
				<option value="end"><?php esc_html_e( 'ends with', 'woocommerce-advbulkedit');?></option>
			</select>
			<input id="descvalue" type="text" class="showorcheckbox"/>
			</td>
				<td><?php echo $arrTranslated['post_excerpt']; ?>: </td>
				<td data-id="post_excerpt">
				<select id="shortdescparams">
				<option value="con"><?php esc_html_e( 'contains', 'woocommerce-advbulkedit');?></option>
				<option value="notcon"><?php esc_html_e( 'does not contain', 'woocommerce-advbulkedit');?></option>
				<option value="start"><?php esc_html_e( 'starts with', 'woocommerce-advbulkedit');?></option>
				<option value="end"><?php esc_html_e( 'ends with', 'woocommerce-advbulkedit');?></option>
			</select>
			<input id="shortdescvalue" type="text" class="showorcheckbox"/>
			</td>
			</tr>
			<tr class="showstocksearch"
			<?php
				$echovar = 'style="display: none"';
				if(is_array($settings))
				{
					if(isset($settings['showstocksearch']))
					{
						if($settings['showstocksearch'] == 1)
						{
							$echovar = "";
						}
					}
				}
				echo $echovar;
			?>
			>
				<td><?php echo $arrTranslated['_stock']; ?>: </td>
				<td>
				<select id="stockqtyparams">
					<option value="more">></option>
					<option value="less"><</option>
					<option value="equal">==</option>
					<option value="moree">>=</option>
					<option value="lesse"><=</option>
				</select>
				<input id="stockqtyvalue" type="text"/>
			</td>
				<td>&nbsp;</td>
				<td>
				&nbsp;
			</td>
			</tr>
			</tbody>
			</table>
			<br/><div id="filterstatus"></div><br/>
			<div id="loadsavediv">
			 <button id="getproducts" class="button-primary-wcabe" type="button">
			   <span class="icon-download-1"></span>
				<?php esc_html_e("Get Products","woocommerce-advbulkedit"); ?>
			 </button>
			 &nbsp;&nbsp;
			  <label><input id="getvariations" type="checkbox" <?php
				if(is_array($settings))
				{
					if(isset($settings['isvariations']))
					{
						if($settings['isvariations'] == 1)
						{
							echo 'checked=checked';
						}
					}else
					{
						echo 'checked=checked';
					}
				}else
				{
					echo 'checked=checked';
				}
			  ?>/><?php esc_html_e( 'Variations', 'woocommerce');?></label>

			   <button id="savechanges" class="button-primary-wcabe" type="button">
			   <span class="icon-floppy"></span>
				<?php esc_html_e("Save Changes","woocommerce-advbulkedit"); ?>
				</button>
				 <div style="display: inline-block;position: relative;width:320px;line-height:29px;">
					 <button id="btn-info-save-changes" class="btn-info"></button>
					 <template id="btn-info-save-changes-body">
						 <?php esc_html_e('Changes are saved on the following actions:', 'woocommerce-advbulkedit'); ?>
						 <ul>
							 <li><?php esc_html_e('- Going to a different page of products', 'woocommerce-advbulkedit'); ?></li>
							 <li><?php esc_html_e('- Adding products/variations', 'woocommerce-advbulkedit'); ?></li>
							 <li><?php esc_html_e("- Clicking the 'Save Changes' button", 'woocommerce-advbulkedit'); ?></li>
						 </ul>
					 </template>
				 </div>
			</div>
			<br />

			<?php
				if (file_exists( __DIR__.'/integrations/button-open-print-barcode-tabs.php')) {
					require_once('integrations/button-open-print-barcode-tabs.php');
					W3ExABulkEdit_Integ_ButtonOpenPrintBarcodeTabs::addButtonOpenPrintBarcodeTabs();
					echo "<br/><br/>";
				}
			?>



			<?php
				if (file_exists( __DIR__.'/integrations/copy-paste-variation-prices.php')) {
					require_once('integrations/copy-paste-variation-prices.php');
                    W3ExABulkEdit_Integ_CopyPasteVariationPrices::addButtonCopy();
                    W3ExABulkEdit_Integ_CopyPasteVariationPrices::addButtonPaste();
					echo "<br/><br/>";
				}
			?>



			<?php
				if (file_exists( __DIR__.'/integrations/copy-images-from-simple-to-variations.php')) {
					require_once('integrations/copy-images-from-simple-to-variations.php');
                    W3ExABulkEdit_Integ_CopyPasteImagesFromSimpleProductsToVariations::addButtonCopy();
					echo "<br/><br/>";
				}
			?>


			<div style="position: relative;">
				<label><input id="linkededit" type="checkbox"/>
					<?php esc_html_e( 'Bulk editing mode', 'woocommerce-advbulkedit'); ?>
				</label>
				<button id="btn-info-linked-editing" class="btn-info"></button>
				<template id="btn-info-linked-editing-body">
					<?php echo wp_kses(__( 'When enabled, any change you make on the grid to a single product, will apply to all selected products.<br/><br/>When disabled, the change will apply only to the edited product.', 'woocommerce-advbulkedit'), ['br' => []]); ?>
				</template>
			</div>
			<br />
			<div style="position: relative;" id="mainbuttons">
				 <input id="settings" class="button-wcabe" type="button" value="<?php _e( "Columns", "woocommerce-advbulkedit"); ?>" />
				 <div id="addprodarea">
					<button id="addprodbut" class="button-wcabe" type="button">
					<span class="icon-plus-outline"></span>
					<?php echo $this->mb_ucfirst(esc_html__( "add", "woocommerce-advbulkedit"));?>
					</button>
				</div>
				<div id="duplicateprodarea">
					<button id="duplicateprodbut" class="button-wcabe" type="button">
					<span class="icon-layers"></span>
					<?php esc_html_e( "Duplicate", "woocommerce-advbulkedit");?>
					</button>
				</div>
				<div id="deletearea">
					<button id="deletebut" class="button-wcabe" type="button">
				<span class="icon-trash"></span>
				<?php echo $this->mb_ucfirst(esc_html__( "delete", "woocommerce-advbulkedit"));?>
				</button>
				</div>
				<input id="selectedit" class="button-wcabe" type="button" value="<?php esc_html_e( "Selection Manager", "woocommerce-advbulkedit"); ?>" />
				<button id="bulkedit" class="button-primary-wcabe" type="button">
				<span class="icon-edit"></span>
				<?php echo esc_html_e( "Advanced Bulk Edit", "woocommerce-advbulkedit");?>
				</button>
				<button id="splitvariations" class="button-wcabe" type="button">
					<span class="icon-split"></span>
					<?php echo esc_html_e( "Split Variations", "woocommerce-advbulkedit");?>
				</button>
				<div id="quicksettingsarea">
					<input id="quicksettingsbut" class="button-wcabe" type="button" value="<?php esc_html_e( "Quick Settings", "woocommerce-advbulkedit"); ?>" />
				</div>
				<div id="bulkedittext" style="display: inline-block;"><?php esc_html_e( "Selected rows for bulk editing", "woocommerce-advbulkedit"); ?>:</div><div id="bulkeditinfo"> 0 of 0</div>
                <div class="mainbuttons-right">
					<button class="btn-info" id="btn-info-show-hide-fields"></button>
					<template id="btn-info-show-hide-fields-body">
						<?php esc_html_e('To show more fields in the grid or hide the unused fields, please use the button "Show/Hide Fields"', "woocommerce-advbulkedit"); ?>
						<br><br>
						<?php esc_html_e('If the fields you want to add are not from WooCommerce but from 3rd party plugin, you can try adding them using the button "Find Custom/Meta Fields"', "woocommerce-advbulkedit"); ?>
					</template>
				</div>
			</div>
			<div id="gridholder">
				<div id="myGrid" style="width:100%;height:50vh;"></div>
			</div>
			<div id="pagingholder" style="position:relative;">
			<input id="gotopage" class="button-wcabe" type="button" value="<?php _e( "First", "woocommerce-advbulkedit"); ?>" /><input id="butprevious" class="button-wcabe" type="button" value="<?php _e( "Previous", "woocommerce-advbulkedit"); ?>" /> <?php _e( "Page", "woocommerce-advbulkedit"); ?>:<input id="gotopagenumber" type="text" value="1" style="width:15px;" readonly/> 	<input id="butnext" class="button-wcabe" type="button" value="<?php _e( "Next", "woocommerce-advbulkedit"); ?>" /> <?php _e( "Total records", "woocommerce-advbulkedit"); ?>: <div id="totalrecords" style="display:inline-block;padding:0px 6px;"></div><div id="totalpages" style="display:inline-block;"></div><div id="viewingwhich" style="display:inline-block;padding:0px 6px;"></div></div> <br /><br />
			<div id="revertinfo"><?php _e( "Revert to original value", "woocommerce-advbulkedit"); ?></div>
			<input id="revertselected" class="button-wcabe" type="button" value="<?php _e( "Selected Rows", "woocommerce-advbulkedit"); ?>" />
			<input id="revertall" class="button-wcabe" type="button" value="<?php _e( "All Rows", "woocommerce-advbulkedit"); ?>" />
			<br /><br /><br />


			<input id="viewdialogbut" class="button-wcabe" type="button" value="<?php esc_html_e( "Load/Save View", "woocommerce-advbulkedit"); ?>" />
			<input id="customfieldsbut" class="button-wcabe" type="button" value="<?php esc_html_e( "Custom Fields", "woocommerce-advbulkedit"); ?>" />
			<input id="findcustomfieldsbut" class="button-wcabe" type="button" value="<?php esc_html_e( "Find Custom/Meta Fields", "woocommerce-advbulkedit"); ?>" />
			<button id="pluginsettingsbut" class="button-primary-wcabe" type="button">
			   <span class="icon-cog-outline"></span>
				<?php esc_html_e( "Plugin Settings", "woocommerce-advbulkedit"); ?>
			 </button>
			<input id="exportproducts" class="button-wcabe" type="button" value="<?php esc_html_e( "Export to CSV", "woocommerce-advbulkedit"); ?>" />

			<div class="fileUpload">
    <input id="exportproducts1" class="button-wcabe" type="button" value="<?php esc_html_e( "Update via CSV", "woocommerce-advbulkedit"); ?>"
    <?php
    	$display = 'style="display:none;"';
		if(isset($settings['debugmode']))
		{
			if($settings['debugmode'] == 1)
			{
				$display = "";
			}
		}
		echo $display;
		?>
    />
    <input id="exportbrowse" type="file" class="upload" />
</div>
			<div id="dvCSV"></div>
			<div id="exportinfo"></div>
			<br/><br/><br/>
			<div id="exportdialog">
				<div class="wcabe-warning-text">
					<?php esc_html_e( "Please, note that we've deprecated our CSV import/export functionality in favor of WooCommerce's own CSV import/export. Therefore, we do not provide support for it. Use at your own risk.", 'woocommerce-advbulkedit'); ?>
				</div>
				<hr>
				<div class="oneline-radio-container">
					<input id="exportall" type="radio" value="0" name="exportwhat" checked="checked"><label for="exportall"> <?php esc_html_e( 'All products in table', 'woocommerce-advbulkedit'); ?></label>
					&nbsp;&nbsp;&nbsp;
					<input id="exportsel" type="radio" value="1" name="exportwhat"><label for="exportsel"> <?php esc_html_e( 'Selected products only', 'woocommerce-advbulkedit'); ?></label>
				</div>
				<hr>
				<div class="oneline-radio-container">
					<input id="allfields" type="radio" value="0" name="exportwhichfields" checked="checked"><label for="allfields"> <?php esc_html_e( 'All fields', 'woocommerce-advbulkedit'); ?></label>
					&nbsp;&nbsp;&nbsp;
					<input id="shownfields" type="radio" value="1" name="exportwhichfields"><label for="shownfields"> <?php esc_html_e( 'Visible fields only', 'woocommerce-advbulkedit'); ?></label>
				</div>
				<hr>
				<div>
					<?php esc_html_e( 'Delimiter', 'woocommerce-advbulkedit'); ?>:
					<select id="exportdelimiter">
						<option value=",">,</option>
						<option value=";">;</option>
					</select>
				</div>
				<hr>
				<div>
					<input id="userealmeta" type="checkbox">
					<label for="userealmeta"><?php esc_html_e( 'Use real meta values', 'woocommerce-advbulkedit'); ?></label>
				</div>

			</div>
			<div id="confirmdialog">
				<div>
					<?php esc_html_e( 'Are you sure you want to continue ?', 'woocommerce-advbulkedit'); ?>
				</div>
			</div>
			<div id="addproddialog">
			</div>
			<!--//plugin settings-->
			<div id="pluginsettings">
			<div style="width:100%;height:100%;">
			<br/>
			<!--settings-->
			<div id="pluginsettingstab">
					<ul>
					<li><a href="#pluginsettingstab-1"><?php echo $arrTranslated['trans_main_settings']; ?></a></li>
					<li><a href="#pluginsettingstab-2"><?php echo $arrTranslated['trans_search_settings']; ?></a></li>
					<?php
						if(!empty($this->largeattributes))
						{
							echo '<li><a href="#pluginsettingstab-3">Large Attributes</a></li>';
						}
					?>
					</ul>

					<div id="pluginsettingstab-1">

				<table cellpadding="10" cellspacing="0" style="margin: 0 auto;">
					<tr>
						<td>
							<?php esc_html_e( 'Limit on product retrieval', 'woocommerce-advbulkedit'); ?>
						</td>
						<td>
							<input id="productlimit" type="text" style="width:50px;"
							<?php
								$settings = get_option('w3exabe_settings');
								if(!is_array($settings)) $settings = array();
								if(isset($settings['settlimit']))
								{
									echo 'value="'.$settings['settlimit'].'"';
								}else
								{
									echo ' value="1000"';
								}

							?>
							>
						</td>
					</tr>
					<tr>
						<td width="50%"  style="padding-top: 25px;">
							<?php esc_html_e( 'Save products in batches of', 'woocommerce-advbulkedit'); ?>
						</td>
						<td width="50%"  style="padding-top: 25px;">
							<input id="savebatch" type="text" style="width:50px;" autocomplete="off"
							<?php
								$settings = get_option('w3exabe_settings');
								if(!is_array($settings)) $settings = array();
								if(!isset($settings['savebatch']))
								{
									$settings['savebatch'] = 50;
								}
								if(isset($settings['savebatch']) && is_numeric($settings['savebatch']))
								{
									echo 'value="'.$settings['savebatch'].'"';
								}else
								{
									echo ' value=""';
								}
							?>
							>
							/<?php esc_html_e( 'empty for a single ajax query', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="gettotalnumber" type="checkbox" autocomplete="off"
							<?php
							if(isset($settings['settgetall']))
							{
								if($settings['settgetall'] == 1)
								{
									echo 'checked=checked';
								}
							}?>
							><?php esc_html_e( 'Do not retrieve total number', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'check if you have a large number of products and want to speed up the query', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="deleteimages" type="checkbox"
							<?php
							if(isset($settings['deleteimages']))
							{
								if($settings['deleteimages'] == 1)
								{
									echo 'checked=checked';
								}
							}?>
							><?php esc_html_e( 'Delete images from server/media library when removing from product image/gallery or deleting product', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'This is not revertable ! Use with caution', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="deleteinternal" type="checkbox"
							<?php
							if(isset($settings['deleteinternal']))
							{
								if($settings['deleteinternal'] == 1)
								{
									echo 'checked=checked';
								}
							}?>
							><?php esc_html_e( 'Use sql queries when deleting products', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'will speed up the query', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="retrievevariations" type="checkbox"
							<?php
							if(isset($settings['settgetvars']))
							{
								if($settings['settgetvars'] == 1)
								{
									echo 'checked=checked';
								}
							}?>
							><?php esc_html_e( 'Retrieve all variations on attribute search', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'if the parent has it', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="includechildren" type="checkbox"
							<?php
							if(isset($settings['incchildren']))
							{
								if($settings['incchildren'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Get all children of selected category on search', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="bgetallvarstaxonomies" type="checkbox"
							<?php
							if(isset($settings['bgetallvarstaxonomies']))
							{
								if($settings['bgetallvarstaxonomies'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Retrieve all variations on custom taxonomy search', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="disattributes" type="checkbox"
							<?php
							if(isset($settings['disattributes']))
							{
								if($settings['disattributes'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Disable attribute support', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="useapicalls" type="checkbox"
							<?php
							echo (isset($settings['useapicalls']) && $settings['useapicalls'] == 0) ? "" : "checked=checked";
							?>

							><?php esc_html_e( 'Use API calls when possible', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="treattagsastext" type="checkbox"
							<?php
							if(isset($settings['treattagsastext']))
							{
								if($settings['treattagsastext'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Treat tags as text taxonomy', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="dontcheckusedfor" type="checkbox"
							<?php
							$echotext = "checked=checked";
							if(isset($settings['dontcheckusedfor']))
							{
								if($settings['dontcheckusedfor'] == 0)
								{
									$echotext = "";
								}
							}
							echo $echotext;	 ?>
							><?php esc_html_e( 'Do not check "Used for variations" automatically', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="calldoaction" type="checkbox"
							<?php
							echo (isset($settings['calldoaction']) && $settings['calldoaction'] == 0 ) ? "" : "checked=checked"; ?>
							><?php esc_html_e( 'Call woocommerce action on save', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'for better compatibility with third-party cache plugins', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="calldosavepost" type="checkbox"
							<?php
							$echotext = "";
							if(isset($settings['calldosavepost']))
							{
								if($settings['calldosavepost'] == 1)
								{
									$echotext = "checked=checked";
								}
							}
							echo $echotext;	 ?>
							><?php esc_html_e( 'Call save_post action', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="confirmsave" type="checkbox"
							<?php
							if(isset($settings['confirmsave']))
							{
								if($settings['confirmsave'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Require confirmation on save', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="disablesafety" type="checkbox"
							<?php
							if(isset($settings['disablesafety']))
							{
								if($settings['disablesafety'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Disable safety net on edit', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
						</td>
					</tr>
					<tr>
						<td width="50%"  style="padding-top: 25px;">
							<?php esc_html_e( 'Choose row height (needs page reload)', 'woocommerce-advbulkedit'); ?>
						</td>
						<td width="50%"  style="padding-top: 25px;">
							<select id="rowheight" >
							<?php
								$normal = "selected";
								$medium = "";
								$big = "";
								if(isset($settings['rowheight']) && is_numeric($settings['rowheight']))
								{
									if($settings['rowheight'] == "3")
									{
										$big = 'selected';
									}elseif($settings['rowheight'] == "2")
									{
										$medium = 'selected';
									}else
									{
										$normal = 'selected';
									}
								}
							?>
							<option value ="1" <?php echo $normal; ?>><?php esc_html_e( 'normal', 'woocommerce-advbulkedit'); ?></option>
							<option value ="2" <?php echo $medium; ?>><?php esc_html_e( 'medium', 'woocommerce-advbulkedit'); ?></option>
							<option value ="3" <?php echo $big; ?>><?php esc_html_e( 'big', 'woocommerce-advbulkedit'); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<td width="50%"  style="padding-top: 25px;">
							<?php esc_html_e( 'Set manual table height', 'woocommerce-advbulkedit'); ?>
						</td>
						<td width="50%"  style="padding-top: 25px;">
							<input id="tableheight" type="text" style="width:50px;"
							<?php
								$settings = get_option('w3exabe_settings');
								if(!is_array($settings)) $settings = array();
								if(isset($settings['tableheight']) && is_numeric($settings['tableheight']))
								{
									echo 'value="'.$settings['tableheight'].'"';
								}else
								{
									echo ' value=""';
								}
							?>
							>
							<?php esc_html_e( 'px', 'woocommerce-advbulkedit'); ?>
						</td>
					</tr>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="setting-disable-hints" type="checkbox"
									<?php
										if(isset($settings['setting_disable_hints']))
										{
											if($settings['setting_disable_hints'] == 1)
											{
												echo 'checked=checked';
											}
										}
									?>
								><?php esc_html_e( 'Disable hints (needs page reload)', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'Use it if you have issues with JS errors, caused by other plugins', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>

					<?php
						if (
								!defined('WCABE_CANT_ACCESS_ADMIN_PLUGIN_SETTINGS') ||
								(defined('WP_ALLOW_MULTISITE') && WP_ALLOW_MULTISITE)
						) {
					?>
					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="setting-enable-admin-only-visible" type="checkbox"
									<?php
									if(isset($settings['setting_enable_admin_only_visible']))
									{
										if($settings['setting_enable_admin_only_visible'] == 1)
										{
											echo 'checked=checked';
										}
									}
									?>
								><?php esc_html_e( 'Only users with Administrator role can see this plugin', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							/<?php esc_html_e( 'Use it to restrict the plugin access', 'woocommerce-advbulkedit'); ?>/
						</td>
					</tr>
					<?php }; ?>

					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="setting-display-topbar-bulkedit-link" type="checkbox"
									<?php
									if(isset($settings['setting_display_top_bar_link_bulkedit']))
									{
										if($settings['setting_display_top_bar_link_bulkedit'] == 1)
										{
											echo 'checked=checked';
										}
									}
									?>
								><?php esc_html_e( 'Hide topbar link "Bulk Edit Products" (needs page reload)', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">

						</td>
					</tr>

					<tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="setting-add-set-time-limit-to-ajax-handler-link" type="checkbox"
									<?php
									echo (	!isset($settings['setting_set_time_limit_for_ajax_requests']) ||
											$settings['setting_set_time_limit_for_ajax_requests'] == 0) ?
											"" : "checked=checked";
									?>
								><?php esc_html_e( 'Disable execution time limit', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
							<p><?php esc_html_e( 'Shops with lots of products could benefit from this option.', 'woocommerce-advbulkedit'); ?></p>
						</td>
					</tr>

                    <tr>
						<td width="50%" style="padding-top: 20px;">
							<label><input id="debugmode" type="checkbox"
							<?php
							if(isset($settings['debugmode']))
							{
								if($settings['debugmode'] == 1)
								{
									echo 'checked=checked';
								}
							}
							?>
							><?php esc_html_e( 'Enable debug mode', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td  style="padding-top: 20px;">
						</td>
					</tr>
				</table>
				</div>
				<div id="pluginsettingstab-2">
					<?php
					$fixed_filter_options = [
						'showattributes' => esc_html__( 'Attributes', 'woocommerce-advbulkedit'),
						'showprices' => esc_html__( 'Regular/Sale Price', 'woocommerce-advbulkedit'),
						'showskutags' => esc_html__( 'SKU/Tags', 'woocommerce-advbulkedit'),
						'showdescriptions' => esc_html__( 'Long/Short Descriptions', 'woocommerce-advbulkedit'),
						'showidsearch' => esc_html__( 'ID', 'woocommerce-advbulkedit'),
						'showstocksearch' => esc_html__( 'Stock Qty', 'woocommerce-advbulkedit'),
					];

					foreach ($fixed_filter_options as $option_name => $option_title) {
						$checked = isset($settings[$option_name]) && $settings[$option_name] == 0 ? '' : 'checked=checked';
						?>
						<div class="customfield-fixed">
							<label>
								<input type="checkbox" id="<?php echo $option_name; ?>" <?php echo $checked; ?> >
								<?php echo $option_title; ?>
							</label>
						</div>
					<?php } ?>
				</div>
					<?php
						if(!empty($this->largeattributes))
						{
							echo '<div id="pluginsettingstab-3"><div style="margin-top:32px;"></div>';
							foreach($this->largeattributes as $lattr)
							{
								$checked = '';
								if($lattr['status'] === "1")
								{
									$checked = "checked=checked";
								}
								echo '<div class="largeattr"><label><input type="checkbox" data-id="'.$lattr['name'].'" '.$checked.' autocomplete="off">'.$lattr['label'].'</label></div>';
							}
							echo '<div style="clear:both;width:1px;height:1px;"></div><br><div class="largeattr_info">(NOTE: Needs page reload for the changes to take effect)</div></div>';
						}
					?>
				</div>
				</div>
			</div>
			<?php
				$setnew = esc_html__( 'set new', 'woocommerce-advbulkedit');
				$prepend = esc_html__( 'prepend', 'woocommerce-advbulkedit');
				$append = esc_html__( 'append', 'woocommerce-advbulkedit');
				$replacetext = esc_html__( 'replace text', 'woocommerce-advbulkedit');
				$ignorecase = esc_html__( 'Ignore case', 'woocommerce-advbulkedit');
				$withtext = esc_html__( 'with text', 'woocommerce-advbulkedit');
				$delete = esc_html__( 'delete', 'woocommerce-advbulkedit');
			    echo '<script>';echo PHP_EOL;
				if(isset($settings['showidsearch']))
				{
					if($settings['showidsearch'] == 1)
					{
						echo 'W3Ex.w3ex_show_id_search ="1";';  echo PHP_EOL;
					}
				}
				echo 'W3Ex.trans_setnew = "'.$setnew.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_prepend = "'.$prepend.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_append = "'.$append.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_replacetext = "'.$replacetext.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_ignorecase = "'.$ignorecase.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_withtext = "'.$withtext.'";'; echo PHP_EOL;						echo 'W3Ex.trans_delete = "'.$delete.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_incbyvalue = "'.esc_html__( "increase by value", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_decbyvalue = "'.esc_html__( "decrease by value", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_incbyper = "'.esc_html__( "increase by %", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_decbyper = "'.esc_html__( "decrease by %", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_movetrash = "'.esc_html__( "Move to Trash", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_delperm = "'.esc_html__( "Delete Permanently", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_products = "'.esc_html__( "Products", "woocommerce").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_variations = "'.esc_html__( "Variations", "woocommerce").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_duplicate = "'.esc_html__( "Duplicate", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_times = "'.esc_html__( "Time(s)", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_add = "'.esc_html__( "add", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_linkednote = "'.esc_html__( "Note ! - Linked editing is turned on, all new variations will be added to all of the selected products. A large number of products * variations can cause a php timeout", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_attributes = "'.esc_html__( "Attributes", "woocommerce").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_select = "'.esc_html__( "Select", "woocommerce").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_bulkadd = "'.esc_html__( "Bulk Add", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_addsingle = "'.esc_html__( "Add Single Variation", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo 'W3Ex.trans_seldoesnot = "'.esc_html__( "Selected product does not have any attributes", "woocommerce-advbulkedit").'";'; echo PHP_EOL;
				echo "</script>";
			 ?>
			<!--//bulk dialog-->
			<div id="bulkdialog">
			<table class="custstyle-table">
				<tr data-id="post_title" style="display: table-row;">
					<td style="width:20% !important;">
						<?php echo $arrTranslated['post_title'];  ?>
					</td>
					<td>
						 <select id="bulkpost_title" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulkpost_titlevalue" type="text" placeholder="Skipped (empty)" data-id="post_title" class="bulkvalue"/>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <input class="inputwithvalue" type="text"></div>
					</td>
				</tr>
				<tr data-id="post_content">
					<td>
						<?php echo $arrTranslated['post_content']; ?>
					</td>
					<td>
						 <select id="bulkpost_content" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<textarea id="bulkpost_contentvalue" rows="1" cols="15" data-id="post_content" class="bulkvalue" placeholder="Skipped (empty)"></textarea>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <textarea class="inputwithvalue" rows="1" cols="15"></textarea></div>
					</td>
				</tr>
				<tr data-id="post_excerpt">
					<td>
						<?php echo $arrTranslated['post_excerpt']; ?>
					</td>
					<td>
						 <select id="bulkpost_excerpt" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<textarea id="bulkpost_excerptvalue" rows="1" cols="15" data-id="post_excerpt" class="bulkvalue" placeholder="Skipped (empty)"></textarea>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <textarea class="inputwithvalue" rows="1" cols="15"></textarea></div>
					</td>
				</tr>
				<tr data-id="post_name">
					<td>
						<?php echo $arrTranslated['post_name']; ?>
					</td>
					<td>
						 <select id="bulkpost_name" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<textarea id="bulkpost_namevalue" rows="1" cols="15" data-id="post_name" class="bulkvalue" placeholder="Skipped (empty)"></textarea>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <textarea class="inputwithvalue" rows="1" cols="15"></textarea></div>
					</td>
				</tr>
				<tr data-id="_sku">
					<td>
						<?php echo $arrTranslated['_sku']; ?>
					</td>
					<td>
						 <select id="bulk_sku" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="fillseries">fill series</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_skuvalue" type="text" data-id="_sku" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <input class="inputwithvalue" type="text"></div>
					</td>
				</tr>
				<tr data-id="product_cat">
					<td>
						<input id="setproduct_cat" type="checkbox" class="bulkset" data-id="product_cat" data-type="customtaxh"><label for="setproduct_cat"><?php echo $arrTranslated['product_cat']; ?></label>
					</td>
					<td>
						 <select id="bulkaddproduct_cat" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="add"><?php esc_html_e( "add", "woocommerce-advbulkedit"); ?></option>
							<option value="remove"><?php esc_html_e( "remove", "woocommerce-advbulkedit"); ?></option>
						</select><button class="butnewattribute button-wcabe button-be-wcabe" type="button"><span class="icon-plus-outline"></span>new</button>
						<div class="divnewattribute">
		   <input class="inputnewattributename" type="text" placeholder="name" data-slug="product_cat"></input><br/>
		   <input class="inputnewattributeslug" type="text" placeholder="slug (optional)"></input><br/>
		   <select class="selectnewcategory" data-placeholder="select parent(optional)" multiple></select><br/>
		   <button class="butnewattributesave butbulkdialog newcat" style="position:relative;">Ok</button><button class="butnewattributecancel newcat">Cancel</button></div>
		   <div class="divnewattributeerror"></div>
					</td>
					<td class="nontextnumbertd">
						 <select id="bulkproduct_cat" class="makechosen catselset" style="width:250px;" data-placeholder="select category" multiple >
						 <option value=""></option>
						<?php
							if(count($newcats) == count($cats))
							{
								foreach($newcats as $catin)
								{
									$depthstring = '';
									if(isset($depth[$catin->term_id]))
									{
										$depthn = (int)$depth[$catin->term_id];
										if($depthn < 15)
										{
											while($depthn > 0)
											{
												$depthstring = $depthstring.'&nbsp;&nbsp;&nbsp;';
												$depthn--;
											}

										}
									}
									echo '<option value="'.$catin->term_id.'" >'.$depthstring.$catin->category_name.'</option>';
								}
							}else
							{
								foreach($cats as $catin)
								{
									echo '<option value="'.$catin->term_id.'" >'.$catin->category_name.'</option>';
								}
							}
						?>
						</select>

					</td>
					<td>

					</td>
				</tr>
				<tr data-id="product_tag">
					<td>
						<input id="setproduct_tag" type="checkbox" class="bulkset" data-id="product_tag" data-type="customtaxh"><label for="setproduct_tag"><?php echo $arrTranslated['product_tag']; ?></label>
					</td>
					<td>
						 <select id="bulkaddproduct_tag" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="add"><?php esc_html_e( "add", "woocommerce-advbulkedit"); ?></option>
							<option value="remove"><?php esc_html_e( "remove", "woocommerce-advbulkedit"); ?></option>
						</select><button class="butnewattribute button-wcabe button-be-wcabe" type="button"><span class="icon-plus-outline"></span>new</button>
						<div class="divnewattribute">
		   <input class="inputnewattributename" type="text" placeholder="name" data-slug="product_tag"></input><br/>
		   <input class="inputnewattributeslug" type="text" placeholder="slug (optional)"></input><br/>
		   <button class="butnewattributesave butbulkdialog newcat" style="position:relative;">Ok</button><button class="butnewattributecancel newcat">Cancel</button></div>
		   <div class="divnewattributeerror"></div>
					</td>
					<td class="nontextnumbertd">
						 <select id="bulkproduct_tag" class="makechosen catselset" style="width:250px;" data-placeholder="select tags" multiple >
						 <option value=""></option>
						<?php
							$args = array(
							    'number'     => 99999,
							    'orderby'    => 'slug',
							    'order'      => 'ASC',
							    'hide_empty' => false,
							    'include'    => '',
								'fields'     => 'all'
							);
							$getquery = "SELECT t.name,tt.term_taxonomy_id,tt.term_id FROM {$wpdb->prefix}terms as t INNER JOIN {$wpdb->prefix}term_taxonomy AS tt ON t.term_id= tt.term_id WHERE tt.taxonomy IN('product_tag')";
							$woo_tags = $wpdb->get_results($getquery);
							if(!is_wp_error($woo_tags) && is_array($woo_tags))
							{
								foreach($woo_tags as $tag)
								{
									 if(!is_object($tag)) continue;
									 if(!property_exists($tag,'term_taxonomy_id')) continue;
									 if(!property_exists($tag,'term_id')) continue;
									 if(!property_exists($tag,'name')) continue;
									 if($this->iswpml)
									{
										 if(ICL_LANGUAGE_CODE !== 'all')
										 {
												 $id = self::lang_category_id($tag->term_taxonomy_id,'product_tag');
											 if($id === NULL || $id != $tag->term_taxonomy_id)
													continue;
										 }
										}
									 echo '<option value="'.$tag->term_id.'" >'.$tag->name.'</option>';
								};
							}
						?>
						</select>

					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_regular_price">
					<td>
						<?php echo $arrTranslated['_regular_price']; ?>
					</td>
					<td>
						 <select id="bulk_regular_price" data-id="_regular_price" class="bulksetdecimal">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="incpercent"><?php esc_html_e( "increase by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decpercent"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
					    <div class="imgButton sm mapto">
					    </div>
						<input id="bulk_regular_pricevalue" type="text" data-id="_regular_price" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						 <select id="bulk_regular_price_round" data-info-block-id="bulk_regular_price_round_info" style="display: none;">
						 	<option value="noround"><?php esc_html_e( "no rounding", "woocommerce-advbulkedit"); ?></option>
							<option value="excelround"><?php esc_html_e( "excel-like (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="excelround1"><?php esc_html_e( "excel-like (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="excelround01"><?php esc_html_e( "excel-like (0.01)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup100"><?php esc_html_e( "round-up (100)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup10"><?php _e( "round-up (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup"><?php esc_html_e( "round-up (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup1"><?php esc_html_e( "round-up (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup01"><?php esc_html_e( "round-up (0.01)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown01"><?php esc_html_e( "round-down (0.01)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown1"><?php esc_html_e( "round-down (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown"><?php esc_html_e( "round-down (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown10"><?php esc_html_e( "round-down (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown100"><?php esc_html_e( "round-down (100)", "woocommerce-advbulkedit"); ?></option>
						 </select>
						<div id="bulk_regular_price_round_info" style="visibility: hidden; display: inline-block;">
							Example: <strong>123.1234</strong> &#x2192;  <strong>123.12</strong> &#9670; <strong>57.4561</strong> &#x2192;  <strong>57.45</strong>
						</div>

					</td>
				</tr>
				<tr data-id="_sale_price">
					<td>
						<?php echo $arrTranslated['_sale_price']; ?>
					</td>
					<td>
						 <select id="bulk_sale_price" data-id="_sale_price" class="bulksetdecimal">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="incpercent"><?php esc_html_e( "increase by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decpercent"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decvaluereg"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?> (from reg.)</option>
							<option value="decpercentreg"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?> (from reg.)</option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						 <div class="imgButton sm mapto">
					    </div>
						<input id="bulk_sale_pricevalue" type="text" data-id="_sale_price" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
					 	 <select id="bulk_sale_price_round" data-info-block-id="bulk_sale_price_round_info" style="display: none;">
						 	<option value="noround"><?php esc_html_e( "no rounding", "woocommerce-advbulkedit"); ?></option>
							<option value="excelround"><?php esc_html_e( "excel-like (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="excelround1"><?php esc_html_e( "excel-like (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="excelround01"><?php esc_html_e( "excel-like (0.01)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup100"><?php esc_html_e( "round-up (100)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup10"><?php esc_html_e( "round-up (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup"><?php esc_html_e( "round-up (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup1"><?php esc_html_e( "round-up (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup01"><?php esc_html_e( "round-up (0.01)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown01"><?php esc_html_e( "round-down (0.01)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown1"><?php esc_html_e( "round-down (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown"><?php esc_html_e( "round-down (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown10"><?php esc_html_e( "round-down (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown100"><?php esc_html_e( "round-down (100)", "woocommerce-advbulkedit"); ?></option>
						 </select>
						<input type="checkbox" id="saleskip"><label id="saleskiplabel" for="saleskip"> Skip products that have a sale price</label>
						<div id="bulk_sale_price_round_info" style="visibility: hidden; display: inline-block;">
							Example: <strong>123.1234</strong> &#x2192;  <strong>123.12</strong> &#9670; <strong>57.4561</strong> &#x2192;  <strong>57.45</strong>
						</div>
					</td>
				</tr>
				<tr data-id="_tax_status">
					<td>
						<input id="set_tax_status" type="checkbox" class="bulkset" data-id="_tax_status"><label for="set_tax_status"><?php echo $arrTranslated['_tax_status']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_tax_status">
							<option value="Taxable">Taxable</option>
							<option value="Shipping only">Shipping only</option>
							<option value="None">None</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_tax_class">
					<td>
						<input id="set_tax_class" type="checkbox" class="bulkset" data-id="_tax_class"><label for="set_tax_class"><?php echo $arrTranslated['_tax_class']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_tax_class">
							<option value="Standard">Standard</option>
							<option value="Reduced Rate">Reduced Rate</option>
							<option value="Zero Rate">Zero Rate</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_weight">
					<td>
						<?php echo $arrTranslated['_weight']; ?>
					</td>
					<td>
						 <select id="bulk_weight" data-id="_weight" class="bulksetdecimal">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="incpercent"><?php esc_html_e( "increase by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decpercent"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?></option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_weightvalue" type="text" data-id="_weight" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						 <select id="bulk_weight_round" style="display:none;">
						 	<option value="noround"><?php esc_html_e( "no rounding", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup100"><?php esc_html_e( "round-up (100)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup10"><?php esc_html_e( "round-up (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup"><?php esc_html_e( "round-up (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup1"><?php esc_html_e( "round-up (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown1"><?php esc_html_e( "round-down (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown"><?php esc_html_e( "round-down (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown10"><?php esc_html_e( "round-down (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown100"><?php esc_html_e( "round-down (100)", "woocommerce-advbulkedit"); ?></option>
						 </select>
					</td>
				</tr>
				<tr data-id="_height">
					<td>
						<?php echo $arrTranslated['_height']; ?>
					</td>
					<td>
						 <select id="bulk_height" data-id="_height" class="bulksetdecimal">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="incpercent"><?php esc_html_e( "increase by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decpercent"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?></option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_heightvalue" type="text" data-id="_height" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						 <select id="bulk_height_round" style="display:none;">
						 	<option value="noround"><?php esc_html_e( "no rounding", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup100"><?php esc_html_e( "round-up (100)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup10"><?php esc_html_e( "round-up (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup"><?php esc_html_e( "round-up (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup1"><?php esc_html_e( "round-up (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown1"><?php esc_html_e( "round-down (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown"><?php esc_html_e( "round-down (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown10"><?php esc_html_e( "round-down (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown100"><?php esc_html_e( "round-down (100)", "woocommerce-advbulkedit"); ?></option>
						 </select>
					</td>
				</tr>
				<tr data-id="_width">
					<td>
						<?php echo $arrTranslated['_width']; ?>
					</td>
					<td>
						 <select id="bulk_width" data-id="_width" class="bulksetdecimal">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="incpercent"><?php esc_html_e( "increase by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decpercent"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?></option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_widthvalue" type="text" data-id="_width" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						 <select id="bulk_width_round" style="display:none;">
						 	<option value="noround"><?php esc_html_e( "no rounding", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup100"><?php esc_html_e( "round-up (100)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup10"><?php esc_html_e( "round-up (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup"><?php esc_html_e( "round-up (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup1"><?php esc_html_e( "round-up (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown1"><?php esc_html_e( "round-down (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown"><?php esc_html_e( "round-down (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown10"><?php esc_html_e( "round-down (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown100"><?php esc_html_e( "round-down (100)", "woocommerce-advbulkedit"); ?></option>
						 </select>
					</td>
				</tr>
				<tr data-id="_length">
					<td>
						<?php echo $arrTranslated['_length']; ?>
					</td>
					<td>
						 <select id="bulk_length" data-id="_length" class="bulksetdecimal">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="incpercent"><?php esc_html_e( "increase by %", "woocommerce-advbulkedit"); ?></option>
							<option value="decpercent"><?php esc_html_e( "decrease by %", "woocommerce-advbulkedit"); ?></option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_lengthvalue" type="text" data-id="_length" class="bulkvalue" placeholder="Skipped (empty)" />
					</td>
					<td>
						 <select id="bulk_length_round" style="display:none;">
						 	<option value="noround"><?php esc_html_e( "no rounding", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup100"><?php esc_html_e( "round-up (100)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup10"><?php esc_html_e( "round-up (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup"><?php esc_html_e( "round-up (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="roundup1"><?php esc_html_e( "round-up (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown1"><?php esc_html_e( "round-down (0.1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown"><?php esc_html_e( "round-down (1)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown10"><?php esc_html_e( "round-down (10)", "woocommerce-advbulkedit"); ?></option>
							<option value="rounddown100"><?php esc_html_e( "round-down (100)", "woocommerce-advbulkedit"); ?></option>
						 </select>
					</td>
				</tr>
				<tr data-id="_stock">
					<td>
						<?php echo $arrTranslated['_stock']; ?>
					</td>
					<td>
						 <select id="bulk_stock" data-id="_stock" class="bulkselectinteger">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_stockvalue" type="text" data-id="_stock" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_stock_status">
					<td>
						<input id="set_stock_status" type="checkbox" class="bulkset" data-id="_stock_status"><label for="set_stock_status"><?php echo $arrTranslated['_stock_status']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_stock_status">
							<option value="instock">In stock</option>
							<option value="outofstock">Out of stock</option>
							<?php
							if(isset($woocommerce) && property_exists($woocommerce,'version'))
							{
								$version = (double)$woocommerce->version;
								if($version >= 3.3)
								{
									echo '<option value="onbackorder">On backorder</option>';
								}
							}
							?>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_manage_stock">
					<td>
						<input id="set_manage_stock" type="checkbox" class="bulkset" data-id="_manage_stock"><label for="set_manage_stock"><?php echo $arrTranslated['_manage_stock']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_manage_stock">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_backorders">
					<td>
						<input id="set_backorders" type="checkbox" class="bulkset" data-id="_backorders"><label for="set_backorders"><?php echo $arrTranslated['_backorders']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_backorders">
							<option value="Do not allow">Do not allow</option>
							<option value="Allow but notify">Allow but notify</option>
							<option value="Allow">Allow</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_sold_individually">
					<td>
						<input id="set_sold_individually" type="checkbox" class="bulkset" data-id="_sold_individually"><label for="set_sold_individually"><?php echo $arrTranslated['_sold_individually']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_sold_individually">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="product_shipping_class">
					<td>
						<input id="setproduct_shipping_class" type="checkbox" class="bulkset" data-id="product_shipping_class" data-type="customtaxh"><label for="setproduct_shipping_class"><?php echo $arrTranslated['product_shipping_class']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulkproduct_shipping_class" class="makechosen catselset" style="width:250px;" data-placeholder="select">
						 <option value="">none</option>
						<?php
							//shipping class
						$args = array(
						    'number'     => 99999,
						    'orderby'    => 'slug',
						    'order'      => 'ASC',
						    'hide_empty' => false,
						    'include'    => '',
							'fields'     => 'all'
						);

						$woo_categories = get_terms( 'product_shipping_class', $args );
						foreach($woo_categories as $category){
						    if(!is_object($category)) continue;
						    if(!property_exists($category,'name')) continue;
						    if(!property_exists($category,'term_id')) continue;
						   	echo '<option value="'.$category->term_id.'" >'.$category->name.'</option>';
						};
						?>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_purchase_note">
					<td>
						<?php echo $arrTranslated['_purchase_note']; ?>
					</td>
					<td>
						 <select id="bulk_purchase_note" class="bulkselect" data-id="_purchase_note">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<textarea id="bulk_purchase_notevalue" rows="1" cols="15" data-id="_purchase_note" class="bulkvalue" placeholder="Skipped (empty)"></textarea>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <textarea class="inputwithvalue" rows="1" cols="15"></textarea></div>
					</td>
				</tr>
				<tr data-id="post_status">
					<td>
						<input id="setpost_status" type="checkbox" class="bulkset" data-id="post_status"><label for="setpost_status"><?php echo $arrTranslated['post_status']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulkpost_status">
							<option value="publish">Publish</option>
							<option value="draft">Draft</option>
							<option value="private">Private</option>
							<option value="pending">Pending</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_visibility">
					<td>
						<input id="set_visibility" type="checkbox" class="bulkset" data-id="_visibility"><label for="set_visibility"><?php echo $arrTranslated['_visibility']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_visibility">
							<option value="Catalog/search">Catalog/search</option>
							<option value="Catalog">Catalog</option>
							<option value="Search">Search</option>
							<option value="Hidden">Hidden</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_upsell_ids">
					<td>
						<?php echo $arrTranslated['_upsell_ids']; ?>
					</td>
					<td>
						 <select id="bulk_upsell_ids" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="nontextnumbertd">
						<input id="bulk_upsell_idsvalue" type="text" data-id="_upsell_ids" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <input class="inputwithvalue" type="text"></div>
					</td>
				</tr>
				<tr data-id="_crosssell_ids">
					<td>
						<?php echo $arrTranslated['_crosssell_ids']; ?>
					</td>
					<td>
						 <select id="bulk_crosssell_ids" class="bulkselect">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="nontextnumbertd">
						<input id="bulk_crosssell_idsvalue" type="text" data-id="_crosssell_ids" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <input class="inputwithvalue" type="text"></div>
					</td>
				</tr>
				<tr data-id="_downloadable">
					<td>
						<input id="set_downloadable" type="checkbox" class="bulkset" data-id="_downloadable"><label for="set_downloadable"><?php echo $arrTranslated['_downloadable']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_downloadable">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_virtual">
					<td>
						<input id="set_virtual" type="checkbox" class="bulkset" data-id="_virtual"><label for="set_virtual"><?php echo $arrTranslated['_virtual']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_virtual">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_download_limit">
					<td>
						<?php echo $arrTranslated['_download_limit']; ?>
					</td>
					<td>
						 <select id="bulk_download_limit" data-id="_download_limit" class="bulkselectinteger">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php _e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php _e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<!--<option value="incpercent"><?php _e( "increase by %", "woocommerce-advbulkedit"); ?></option>-->
							<!--<option value="decpercent"><?php _e( "decrease by %", "woocommerce-advbulkedit"); ?></option>-->
							<option value="delete">set unlimited (<?php echo $delete; ?>)</option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_download_limitvalue" type="text" data-id="_download_limit" class="bulkvalue" placeholder="Skipped (empty)" />
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_download_expiry">
					<td>
						<?php echo $arrTranslated['_download_expiry']; ?>
					</td>
					<td>
						 <select id="bulk_download_expiry" data-id="_download_expiry" class="bulkselectinteger">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php _e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php _e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
							<!--<option value="incpercent"><?php _e( "increase by %", "woocommerce-advbulkedit"); ?></option>-->
							<!--<option value="decpercent"><?php _e( "decrease by %", "woocommerce-advbulkedit"); ?></option>-->
							<option value="delete">set unlimited (<?php echo $delete; ?>)</option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_download_expiryvalue" type="text" data-id="_download_expiry" class="bulkvalue" placeholder="Skipped (empty)" />
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_download_type">
					<td>
						<input id="set_download_type" type="checkbox" class="bulkset" data-id="_download_type"><label for="set_download_type"><?php echo $arrTranslated['_download_type']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_download_type">
							<option value="Standard">Standard</option>
							<option value="Application">Application</option>
							<option value="Music">Music</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_featured">
					<td>
						<input id="set_featured" type="checkbox" class="bulkset" data-id="_featured"><label for="set_featured"><?php echo $arrTranslated['_featured']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulk_featured">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_product_url">
					<td>
						<?php echo $arrTranslated['_product_url']; ?>
					</td>
					<td>
						 <select id="bulk_product_url" class="bulkselect" data-id="_product_url">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_product_urlvalue" type="text" data-id="_product_url" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <input class="inputwithvalue" type="text"></div>
					</td>
				</tr>
				<tr data-id="_button_text">
					<td>
						<?php echo $arrTranslated['_button_text']; ?>
					</td>
					<td>
						 <select id="bulk_button_text" class="bulkselect" data-id="_button_text">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
							<option value="delete"><?php echo $delete; ?></option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulk_button_textvalue" type="text" data-id="_button_text" class="bulkvalue" placeholder="Skipped (empty)"/>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <input class="inputwithvalue" type="text"></div>
					</td>
				</tr>
				<tr data-id="menu_order">
					<td>
						<?php echo $arrTranslated['menu_order']; ?>
					</td>
					<td>
						 <select id="bulkmenu_order" data-id="menu_order">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="incvalue"><?php esc_html_e( "increase by value", "woocommerce-advbulkedit"); ?></option>
							<option value="decvalue"><?php esc_html_e( "decrease by value", "woocommerce-advbulkedit"); ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<input id="bulkmenu_ordervalue" type="text" data-id="menu_order" class="bulkvalue" placeholder="Skipped (empty)" />
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_variation_description">
					<td>
						<?php echo $arrTranslated['_variation_description']; ?>
					</td>
					<td>
						 <select id="bulk_variation_description" class="bulkselect" data-id="_variation_description">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="prepend"><?php echo $prepend; ?></option>
							<option value="append"><?php echo $append; ?></option>
							<option value="replace"><?php echo $replacetext; ?></option>
							<option value="replaceregexp">replace regexp</option>
						</select>
						<label class="labelignorecase" style="display:none;">
						<input class="inputignorecase" type="checkbox">
						<?php echo $ignorecase; ?></label>
					</td>
					<td class="tdbulkvalue">
						<div class="imgButton sm mapto">
					    </div>
						<textarea id="bulk_variation_descriptionevalue" rows="1" cols="15" data-id="_variation_description" class="bulkvalue" placeholder="Skipped (empty)"></textarea>
					</td>
					<td>
						<div class="divwithvalue" style="display:none;"><?php echo $withtext; ?> <textarea class="inputwithvalue" rows="1" cols="15"></textarea></div>
					</td>
				</tr>
				<tr data-id="product_type">
					<td>
						<input id="setproduct_type" type="checkbox" class="bulkset" data-id="product_type" data-type="customtaxh"><label for="setproduct_type"><?php echo $arrTranslated['product_type']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulkproduct_type" class="makechosen catselset" style="width:250px;" data-placeholder="select">
						<?php
							//categories
						$args = array(
						    'number'     => 99999,
						    'orderby'    => 'slug',
						    'order'      => 'ASC',
						    'hide_empty' => false,
						    'include'    => '',
							'fields'     => 'all'
						);

						$woo_categories = get_terms( 'product_type', $args );
						foreach($woo_categories as $category){
						    if(!is_object($category)) continue;
						    if(!property_exists($category,'name')) continue;
						    if(!property_exists($category,'term_id')) continue;
						   	echo '<option value="'.$category->term_id.'" >'.$category->name.'</option>';
						};
						?>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="comment_status">
					<td>
						<input id="setcomment_status" type="checkbox" class="bulkset" data-id="comment_status"><label for="setcomment_status"><?php echo $arrTranslated['comment_status']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulkcomment_status">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="grouped_items">
					<td>
						<input id="setgrouped_items" type="checkbox" class="bulkset" data-id="grouped_items" data-type="customtaxh"><label for="setgrouped_items"><?php echo $arrTranslated['grouped_items']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
					<?php
						$multiple = "";
					?>
						 <select id="bulkgrouped_items" class="makechosen catselset" style="width:250px;" data-placeholder="select" <?php echo $multiple; ?>>
						 <option value="0"> Choose a grouped product...</option>
						<?php
						$argsgr = array(
							'posts_per_page'   => 500,
							'post_type' => 'product',
							'product_type' => 'grouped'
						);
						$query = new WP_Query( $argsgr );

						// The Loop
						while ( $query->have_posts() ) {
							$query->the_post();
							echo '<option value="'.$query->post->ID.'" >'.get_the_title().'</option>';
						}
						wp_reset_postdata();
						?>
						</select>
					</td>
					<td>

					</td>
				</tr>
				<tr data-id="_custom_attributes">
					<td>
						<input id="set_custom_attributes" type="checkbox" class="bulkset" data-id="_custom_attributes"><label for="set_custom_attributes">Set <?php echo $arrTranslated['_custom_attributes']; ?></label>
					</td>
					<td>


						 <select id="bulkadd_custom_attributes" class="bulkselect" data-id="_custom_attributes" disabled="disabled">
							<option value="new"><?php echo $setnew; ?></option>
							<option value="addvalue">add value</option>
							<option value="renameattr">rename attr</option>
							<option value="removename"><?php echo $arrTranslated['trans_remove_name']; ?></option>
							<option value="removevalue"><?php echo  $arrTranslated['trans_remove_value']; ?></option>
						</select>
					</td>
					<td class="tdbulkvalue">
					<div id="customname" >
						<label id="custnamelabel">Name:</label>
						<input id="bulk_custom_attributesname" type="text" data-id="_custom_attributes" class="bulkvalue" placeholder="Skipped (empty)"/>
						</div>
						<div id="customvalue">
						<label id="custvaluelabel">Value:</label>
						<input id="bulk_custom_attributesvalue" type="text" data-id="_custom_attributes"/>
						</div>
					</td>
					<td>
						(<select class="selectvisiblefp" disabled data-id="_custom_attributes">
						<option value="skip">skip</option><option value="andset">and set</option><option value="onlyset">only set</option>
						</select>&nbsp;<input type="checkbox" disabled class="visiblefp" data-id="_custom_attributes">Visible on p. p.)&nbsp;
						(<select disabled class="selectusedforvars" data-id="_custom_attributes"><option value="skip">skip</option><option value="andset">and set</option><option value="onlyset">only set</option>
						</select>&nbsp;<input type="checkbox" disabled class="usedforvars" data-id="_custom_attributes">Used for var.)
					</td>
				</tr>
				<tr data-id="post_author">
					<td>
						<input id="setpost_author" type="checkbox" class="bulkset" data-id="post_author" data-type="customtaxh"><label for="setpost_author"><?php echo $arrTranslated['post_author']; ?></label>
					</td>
					<td>

					</td>
					<td class="nontextnumbertd">
						 <select id="bulkpost_author" class="makechosen catselset" style="width:250px;" data-placeholder="select">
						<?php
							foreach ( $blogusers as $user )
							{
								echo '<option value="'.$user->ID.'" >'.$user->display_name.'</option>';
							}
						?>
						</select>
					</td>
					<td>

					</td>
				</tr>
			</table>
			<br/>
			</div>

			<!--//select dialog-->
			<div id="selectdialog">

            <div class="selquickactions">
	            <?php echo apply_filters('wcabe_filter_selection_manager_before_content', ''); ?>
            </div>
			<div class="selquickactions">
                <strong><?php esc_html_e( "Quick Selects", "woocommerce-advbulkedit"); ?>:</strong>
				<a id="selallproducts" href="#" class="sel-manager-quick-action"><?php esc_html_e( "All Products", "woocommerce-advbulkedit"); ?></a>
				<a id="selallvars" href="#" class="sel-manager-quick-action"><?php esc_html_e( "All Variations", "woocommerce-advbulkedit"); ?></a>
				<a id="seldupproducts" href="#" class="sel-manager-quick-action"><?php esc_html_e( "Duplicate Products by:", "woocommerce-advbulkedit"); ?></a>
				<select id="selectdupproducts">
					<option value="post_title"><?php esc_html_e('same title','woocommerce-advbulkedit'); ?></option>
					<option value="post_content"><?php esc_html_e('description','woocommerce-advbulkedit'); ?></option>
					<option value="post_excerpt"><?php esc_html_e('short description','woocommerce-advbulkedit'); ?></option>
				</select>
				<a id="seldupvars" href="#" class="sel-manager-quick-action"><?php _e( "Duplicate Variations", "woocommerce-advbulkedit"); ?></a>
				(<?php _e( "same attributes", "woocommerce-advbulkedit"); ?> )
				<a id="invertselected" href="#" class="sel-manager-quick-action"><?php _e( "Invert selected", "woocommerce-advbulkedit"); ?></a>
			</div>
			<hr />
			<div id="selectdiv">
			<select id="selectselect">
				<option value="select"><?php esc_html_e('select','woocommerce-advbulkedit'); ?></option>
				<option value="deselect"><?php esc_html_e('deselect','woocommerce-advbulkedit'); ?></option>
			</select>
			<select id="selectproduct">
				<option value="prodvar"><?php esc_html_e('products and variations','woocommerce-advbulkedit'); ?></option>
				<option value="prod"><?php esc_html_e('products only','woocommerce-advbulkedit'); ?></option>
				<option value="var"><?php esc_html_e('variations only','woocommerce-advbulkedit'); ?></option>
			</select>
			<?php esc_html_e('which meet','woocommerce-advbulkedit'); ?>
			<select id="selectany">
				<option value="any"><?php esc_html_e('any of the search criteria','woocommerce-advbulkedit'); ?></option>
				<option value="all"><?php esc_html_e('all of the search criteria','woocommerce-advbulkedit'); ?></option>
			</select>
			</div>
			<?php
				$t_contains = esc_html__( 'contains', 'woocommerce-advbulkedit');
				$t_doesnot = esc_html__( 'does not contain', 'woocommerce-advbulkedit');
				$t_starts = esc_html__( 'starts with', 'woocommerce-advbulkedit');
				$t_ends = esc_html__( 'ends with', 'woocommerce-advbulkedit');
				$t_isempty = esc_html__( 'field is empty', 'woocommerce-advbulkedit');
				 echo '<script>'; echo PHP_EOL;
				echo 'W3Ex.trans_contains = "'.$t_contains.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_doesnot = "'.$t_doesnot.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_starts = "'.$t_starts.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_ends = "'.$t_ends.'";'; echo PHP_EOL;
				echo 'W3Ex.trans_isempty = "'.$t_isempty.'";'; echo PHP_EOL;
				echo "</script>";
			 ?>
			<table class="custstyle-table">
				<tr data-id="post_title" style="display: table-row;">
					<td style="width:25% !important;">
						<?php echo $arrTranslated['post_title']; ?>
					</td>
					<td>
						 <select id="selectpost_title" class="selectselect" data-id="post_title">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
						</select>
					</td>
					<td>
						<input id="selectpost_titlevalue" type="text" placeholder="Skipped (empty)" data-id="post_title" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="post_title" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="post_title" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="post_content">
					<td>
						<?php echo $arrTranslated['post_content']; ?>
					</td>
					<td>
						 <select id="selectpost_content" class="selectselect" data-id="post_content">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<textarea cols="15" rows="1" id="selectpost_contentvalue" placeholder="Skipped (empty)" data-id="post_content" class="selectvalue"></textarea >
					</td>
					<td>
						<label><input data-id="post_content" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="post_content" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="post_excerpt">
					<td>
						<?php echo $arrTranslated['post_excerpt']; ?>
					</td>
					<td>
						 <select id="selectpost_excerpt" class="selectselect" data-id="post_excerpt">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<textarea cols="15" rows="1" id="selectpost_excerptvalue" placeholder="Skipped (empty)" data-id="post_excerpt" class="selectvalue"></textarea >
					</td>
					<td>
						<label><input data-id="post_excerpt" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="post_excerpt" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="post_name">
					<td>
						<?php echo $arrTranslated['post_name']; ?>
					</td>
					<td>
						 <select id="selectpost_name" class="selectselect" data-id="post_name">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="iscon">is contained in</option>
						</select>
					</td>
					<td>
						<textarea cols="15" rows="1" id="selectpost_namevalue" placeholder="Skipped (empty)" data-id="post_name" class="selectvalue"></textarea >
					</td>
					<td>
						<label><input data-id="post_name" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="post_name" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_sku">
					<td>
						<?php echo $arrTranslated['_sku']; ?>
					</td>
					<td>
						 <select id="select_sku" class="selectselect" data-id="_sku">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_skuvalue" type="text" placeholder="Skipped (empty)" data-id="_sku" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="_sku" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_sku" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="product_cat">
					<td>
						<?php echo $arrTranslated['product_cat']; ?>
					</td>
					<td>
						 <select id="selectproduct_cat" class="selectselect" data-id="product_cat">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectproduct_catvalue" type="text" placeholder="Skipped (empty)" data-id="product_cat" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="product_cat" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="product_cat" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="product_tag">
					<td>
						<?php echo $arrTranslated['product_tag']; ?>
					</td>
					<td>
						 <select id="selectproduct_tag" class="selectselect" data-id="product_tag">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectproduct_tagvalue" type="text" placeholder="Skipped (empty)" data-id="product_tag" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="product_tag" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="product_tag" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_regular_price">
					<td>
						<?php echo $arrTranslated['_regular_price']; ?>
					</td>
					<td>
						 <select id="select_regular_price" class="selectselect" data-id="_regular_price">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_regular_pricevalue" type="text" placeholder="Skipped (empty)"  data-id="_regular_price" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_sale_price">
					<td>
						<?php echo $arrTranslated['_sale_price']; ?>
					</td>
					<td>
						 <select id="select_sale_price" class="selectselect" data-id="_sale_price">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_sale_pricevalue" type="text" placeholder="Skipped (empty)" data-id="_sale_price" class="selectvalue" />
					</td>
					<td>
					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_tax_status">
					<td>
						<input id="setsel_tax_status" type="checkbox" class="selectset" data-id="_tax_status"><label for="setsel_tax_status"><?php echo $arrTranslated['_tax_status']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_tax_status">
							<option value="Taxable">Taxable</option>
							<option value="Shipping only">Shipping only</option>
							<option value="None">None</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_tax_class">
					<td>
						<input id="setsel_tax_class" type="checkbox" class="selectset" data-id="_tax_class"><label for="setsel_tax_class"><?php echo $arrTranslated['_tax_class']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_tax_class">
							<option value="Standard">Standard</option>
							<option value="Reduced Rate">Reduced Rate</option>
							<option value="Zero Rate">Zero Rate</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_weight">
					<td>
						<?php echo $arrTranslated['_weight']; ?>
					</td>
					<td>
						 <select id="select_weight" class="selectselect" data-id="_weight">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_weightvalue" type="text" placeholder="Skipped (empty)" data-id="_weight" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_height" class="selectselect">
					<td>
						<?php echo $arrTranslated['_height']; ?>
					</td>
					<td>
						 <select id="select_height" class="selectselect" data-id="_height">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_heightvalue" type="text" placeholder="Skipped (empty)" data-id="_height" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_width">
					<td>
						<?php echo $arrTranslated['_width']; ?>
					</td>
					<td>
						 <select id="select_width" class="selectselect" data-id="_width">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_widthvalue" type="text" placeholder="Skipped (empty)" data-id="_width" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_length">
					<td>
						<?php echo $arrTranslated['_length']; ?>
					</td>
					<td>
						 <select id="select_length" class="selectselect" data-id="_length">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_lengthvalue" type="text" placeholder="Skipped (empty)" data-id="_length" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_stock">
					<td>
						<?php echo $arrTranslated['_stock']; ?>
					</td>
					<td>
						 <select id="select_stock" class="selectselect" data-id="_stock">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_stockvalue" type="text" placeholder="Skipped (empty)" data-id="_stock" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_stock_status">
					<td>
						<input id="setsel_stock_status" type="checkbox" class="selectset" data-id="_stock_status"><label for="setsel_stock_status"><?php echo $arrTranslated['_stock_status']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_stock_status">
							<option value="instock">In stock</option>
							<option value="outofstock">Out of stock</option>
							<?php
							if(isset($woocommerce) && property_exists($woocommerce,'version'))
							{
								$version = (double)$woocommerce->version;
								if($version >= 3.3)
								{
									echo '<option value="onbackorder">On backorder</option>';
								}
							}
							?>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_manage_stock">
					<td>
						<input id="setsel_manage_stock" type="checkbox" class="selectset" data-id="_manage_stock"><label for="setsel_manage_stock"><?php echo $arrTranslated['_manage_stock']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_manage_stock">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_backorders">
					<td>
						<input id="setsel_backorders" type="checkbox" class="selectset" data-id="_backorders"><label for="setsel_backorders"><?php echo $arrTranslated['_backorders']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_backorders">
							<option value="Do not allow">Do not allow</option>
							<option value="Allow but notify">Allow but notify</option>
							<option value="Allow">Allow</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_sold_individually">
					<td>
						<input id="setsel_sold_individually" type="checkbox" class="selectset" data-id="_sold_individually"><label for="setsel_sold_individually"><?php echo $arrTranslated['_sold_individually']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_sold_individually">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="product_shipping_class">
					<td>
						<?php echo $arrTranslated['product_shipping_class']; ?>
					</td>
					<td>
						 <select id="selectproduct_shipping_class" class="selectselect" data-id="product_shipping_class">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectproduct_shipping_classvalue" type="text" placeholder="Skipped (empty)" data-id="product_shipping_class" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="product_shipping_class" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="product_shipping_class" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_purchase_note">
					<td>
						<?php echo $arrTranslated['_purchase_note']; ?>
					</td>
					<td>
						 <select id="select_purchase_note" class="selectselect" data-id="_purchase_note">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<textarea cols="15" rows="1" id="select_purchase_notevalue" placeholder="Skipped (empty)" data-id="_purchase_note" class="selectvalue"></textarea >
					</td>
					<td>
						<label><input data-id="_purchase_note" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_purchase_note" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="post_status">
					<td>
						<input id="setselpost_status" type="checkbox" class="selectset" data-id="post_status"><label for="setselpost_status"><?php echo $arrTranslated['post_status']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="selectpost_status">
							<option value="publish">Publish</option>
							<option value="draft">Draft</option>
							<option value="private">Private</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_visibility">
					<td>
						<input id="setsel_visibility" type="checkbox" class="selectset" data-id="_visibility"><label for="setsel_visibility"><?php echo $arrTranslated['_visibility']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_visibility">
							<option value="Catalog/search">Catalog/search</option>
							<option value="Catalog">Catalog</option>
							<option value="Search">Search</option>
							<option value="Hidden">Hidden</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_upsell_ids">
					<td>
						<?php echo $arrTranslated['_upsell_ids']; ?>
					</td>
					<td>
						 <select id="select_upsell_ids" class="selectselect" data-id="_upsell_ids">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_upsell_idsvalue" type="text" placeholder="Skipped (empty)" data-id="_upsell_ids" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="_upsell_ids" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_upsell_ids" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_crosssell_ids">
					<td>
						<?php echo $arrTranslated['_crosssell_ids']; ?>
					</td>
					<td>
						 <select id="select_crosssell_ids" class="selectselect" data-id="_crosssell_ids">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_crosssell_idsvalue" type="text" placeholder="Skipped (empty)" data-id="_crosssell_ids" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="_crosssell_ids" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_crosssell_ids" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_downloadable">
					<td>
						<input id="setsel_downloadable" type="checkbox" class="selectset" data-id="_downloadable"><label for="setsel_downloadable"><?php echo $arrTranslated['_downloadable']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_downloadable">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_virtual">
					<td>
						<input id="setsel_virtual" type="checkbox" class="selectset" data-id="_virtual"><label for="setsel_virtual"><?php echo $arrTranslated['_virtual']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_virtual">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_download_limit">
					<td>
						<?php echo $arrTranslated['_download_limit']; ?>
					</td>
					<td>
						 <select id="select_download_limit" class="selectselect" data-id="_download_limit">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_download_limitvalue" type="text" placeholder="Skipped (empty)" data-id="_download_limit" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_download_expiry">
					<td>
						<?php echo $arrTranslated['_download_expiry']; ?>
					</td>
					<td>
						 <select id="select_download_expiry" class="selectselect" data-id="_download_expiry">
						<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?> (unlimited)</option>
						</select>
					</td>
					<td>
						<input id="select_download_expiryvalue" type="text" placeholder="Skipped (empty)" data-id="_download_expiry" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_download_type">
					<td>
						<input id="setsel_download_type" type="checkbox" class="selectset" data-id="_download_type"><label for="setsel_download_type"><?php echo $arrTranslated['_download_type']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_download_type">
							<option value="Standard">Standard</option>
							<option value="Application">Application</option>
							<option value="Music">Music</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_featured">
					<td>
						<input id="setsel_featured" type="checkbox" class="selectset" data-id="_featured"><label for="setsel_featured"><?php echo $arrTranslated['_featured']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="select_featured">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_product_url">
					<td>
						<?php echo $arrTranslated['_product_url']; ?>
					</td>
					<td>
						 <select id="select_product_url" class="selectselect" data-id="_product_url">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_product_urlvalue" type="text" placeholder="Skipped (empty)" data-id="_product_url" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="_product_url" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_product_url" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_button_text">
					<td>
						<?php echo $arrTranslated['_button_text']; ?>
					</td>
					<td>
						 <select id="select_button_text" class="selectselect" data-id="_button_text">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="select_button_textvalue" type="text" placeholder="Skipped (empty)" data-id="_button_text" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="_button_text" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_button_text" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="menu_order">
					<td>
						<?php echo $arrTranslated['menu_order']; ?>
					</td>
					<td>
						 <select id="selectmenu_order" class="selectselect" data-id="menu_order">
							<option value="more">></option>
							<option value="less"><</option>
							<option value="equal">==</option>
							<option value="moree">>=</option>
							<option value="lesse"><=</option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectmenu_ordervalue" type="text" placeholder="Skipped (empty)" data-id="menu_order" class="selectvalue" />
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="_variation_description">
					<td>
						<?php echo $arrTranslated['_variation_description']; ?>
					</td>
					<td>
						 <select id="select_variation_description" class="selectselect" data-id="_variation_description">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<textarea cols="15" rows="1" id="select_variation_descriptionvalue" placeholder="Skipped (empty)" data-id="_variation_description" class="selectvalue"></textarea >
					</td>
					<td>
						<label><input data-id="_variation_description" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_variation_description" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
				</tr>
				<tr data-id="product_type">
					<td>
						<?php echo $arrTranslated['product_type']; ?>
					</td>
					<td>
						 <select id="selectproduct_type" class="selectselect" data-id="product_type">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_ends; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectproduct_typevalue" type="text" placeholder="Skipped (empty)" data-id="product_type" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="product_type" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="product_type" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="comment_status">
					<td>
						<input id="setselcomment_status" type="checkbox" class="selectset" data-id="comment_status"><label for="setselcomment_status"><?php echo $arrTranslated['comment_status']; ?></label>
					</td>
					<td>

					</td>
					<td>
						 <select id="selectcomment_status">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
					<td>

					</td>
					<td>
					</td>
				</tr>
				<tr data-id="grouped_items">
					<td>
						<?php echo $arrTranslated['grouped_items']; ?>
					</td>
					<td>
						 <select id="selectgrouped_items" class="selectselect" data-id="grouped_items">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_ends; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectgrouped_itemsvalue" type="text" placeholder="Skipped (empty)" data-id="grouped_items" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="grouped_items" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="grouped_items" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="_custom_attributes">
					<td>
						<?php echo $arrTranslated['_custom_attributes']; ?>
						<select id="select_custom_attributes_what" data-id="_custom_attributes">
							<option value="name">name</option>
							<option value="value">value</option>
						</select>
					</td>
					<td>
						 <select id="select_custom_attributes" class="selectselect" data-id="_custom_attributes">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<textarea cols="15" rows="1" id="select_custom_attributesvalue" placeholder="Skipped (empty)" data-id="_custom_attributes" class="selectvalue"></textarea >
					</td>
					<td>
						<label><input data-id="_custom_attributes" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="_custom_attributes" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
				<tr data-id="post_author">
					<td>
						<?php echo $arrTranslated['post_author']; ?>
					</td>
					<td>
						 <select id="selectpost_author" class="selectselect" data-id="post_author">
							<option value="con"><?php echo $t_contains; ?></option>
							<option value="notcon"><?php echo $t_doesnot; ?></option>
							<option value="start"><?php echo $t_starts; ?></option>
							<option value="end"><?php echo $t_ends; ?></option>
							<option value="empty"><?php echo $t_isempty; ?></option>
						</select>
					</td>
					<td>
						<input id="selectpost_authorvalue" type="text" placeholder="Skipped (empty)" data-id="post_author" class="selectvalue"/>
					</td>
					<td>
						<label><input data-id="post_author" class="selectifignorecase" type="checkbox"> <?php echo $ignorecase; ?></label>
					</td>
					<td>
						<input data-id="post_author" class="checkboxifspecial" type="checkbox">
						<select class="selectsplit" disabled="disabled"><option value="split"><?php esc_html_e('split commas', 'woocommerce-advbulkedit');?></option><option value="regexp"><?php esc_html_e('reg exp', 'woocommerce-advbulkedit');?></option></select>
						<select class="selectsplitand" disabled="disabled"><option value="and"><?php esc_html_e('AND', 'woocommerce-advbulkedit');?></option><option value="or"><?php esc_html_e('OR', 'woocommerce-advbulkedit');?></option></select>
					</td>
				</tr>
			</table>
			<br/>
			</div>

		<!--
		settings dialog
		-->
			<!--//show/hide fields-->
			<div id="settingsdialog">
			<table class="settings-table" >
				<br/>
				<div class="wcabe-dlg-top-floated">
					<span class="fleft"><input id="searchsettings" type="search" style="width:150px;" placeholder="search"></input></span>
					<span class="fright"> <?php esc_html_e( "Didn't find the field you are looking for? Try to find it in ", 'woocommerce-advbulkedit'); ?> <a href="#" id="findcustomfieldsopen"><?php esc_html_e( 'Custom/Meta Fields', 'woocommerce-advbulkedit'); ?></a></span>
				</div>
				<br/>
				<tr>

					<td>
						<input id="dimage" class="dsettings" data-id="_thumbnail_id" type="checkbox"><label for="dimage"> <?php echo $arrTranslated['_thumbnail_id']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dimage_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="d_product_image_gallery" class="dsettings" data-id="_product_image_gallery" type="checkbox"><label for="d_product_image_gallery"> <?php echo $arrTranslated['_product_image_gallery']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_product_image_gallery_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>

					<td>
						<input id="dmenu_order" class="dsettings" data-id="menu_order" type="checkbox"><label for="dmenu_order"> <?php echo $arrTranslated['menu_order']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dmenu_order_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dfeatured" class="dsettings" data-id="_featured" type="checkbox"><label for="dfeatured"> <?php echo $arrTranslated['_featured']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dfeatured_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dprodcutdescription" class="dsettings" data-id="post_content" type="checkbox"><label for="dprodcutdescription"> <?php echo $arrTranslated['post_content']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dprodcutdescription_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dprodcutexcerpt" class="dsettings" data-id="post_excerpt" type="checkbox"><label for="dprodcutexcerpt"> <?php echo $arrTranslated['post_excerpt']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dprodcutexcerpt_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dpost_name" class="dsettings" data-id="post_name" type="checkbox"><label for="dpost_name"> <?php echo $arrTranslated['post_name']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dpost_name_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dpost_date" class="dsettings" data-id="post_date" type="checkbox"><label for="dpost_date"> <?php echo $arrTranslated['post_date']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dpost_date_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dsku" class="dsettings" data-id="_sku" type="checkbox"><label for="dsku"> <?php echo $arrTranslated['_sku']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dsku_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dproduct_cat" class="dsettings" data-id="product_cat" type="checkbox"><label for="dproduct_cat"> <?php echo $arrTranslated['product_cat']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dproduct_cat_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dproduct_tag" class="dsettings" data-id="product_tag" type="checkbox"><label for="dproduct_tag"> <?php echo $arrTranslated['product_tag']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dproduct_tag_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dproduct_shipping_class" class="dsettings" data-id="product_shipping_class" type="checkbox"><label for="dproduct_shipping_class"> <?php echo $arrTranslated['product_shipping_class']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dproduct_shipping_class_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dregprice" class="dsettings" data-id="_regular_price" type="checkbox"><label for="dregprice"> <?php echo $arrTranslated['_regular_price']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dregprice_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dsaleprice" class="dsettings" data-id="_sale_price" type="checkbox"><label for="dsaleprice"> <?php echo $arrTranslated['_sale_price']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dsaleprice_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dsalefrom" class="dsettings" data-id="_sale_price_dates_from" type="checkbox"><label for="dsalefrom"> <?php echo $arrTranslated['_sale_price_dates_from']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dsalefrom_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dsaleto" class="dsettings" data-id="_sale_price_dates_to" type="checkbox"><label for="dsaleto"> <?php echo $arrTranslated['_sale_price_dates_to']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dsaleto_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dtaxstatus" class="dsettings" data-id="_tax_status" type="checkbox"><label for="dtaxstatus"> <?php echo $arrTranslated['_tax_status']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dtaxstatus_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dtaxclass" class="dsettings" data-id="_tax_class" type="checkbox"><label for="dtaxclass"> <?php echo $arrTranslated['_tax_class']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dtaxclass_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dweight" class="dsettings" data-id="_weight" type="checkbox"><label for="dweight"> <?php echo $arrTranslated['_weight']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dweight_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dheight" class="dsettings" data-id="_height" type="checkbox"><label for="dheight"> <?php echo $arrTranslated['_height']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dheight_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dwidth" class="dsettings" data-id="_width" type="checkbox"><label for="dwidth"> <?php echo $arrTranslated['_width']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dwidth_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dlength" class="dsettings" data-id="_length" type="checkbox"><label for="dlength"> <?php echo $arrTranslated['_length']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dlength_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dstockquantity" class="dsettings" data-id="_stock" type="checkbox"><label for="dstockquantity"> <?php echo $arrTranslated['_stock']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dstockquantity_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dstockstatus" class="dsettings" data-id="_stock_status" type="checkbox"><label for="dstockstatus"> <?php echo $arrTranslated['_stock_status']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dstockstatus_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dmanagestock" class="dsettings" data-id="_manage_stock" type="checkbox"><label for="dmanagestock"> <?php echo $arrTranslated['_manage_stock']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dmanagestock_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dbackorders" class="dsettings" data-id="_backorders" type="checkbox"><label for="dbackorders"> <?php echo $arrTranslated['_backorders']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dbackorders_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dsoldind" class="dsettings" data-id="_sold_individually" type="checkbox"><label for="dsoldind"> <?php echo $arrTranslated['_sold_individually']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dsoldind_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dpurchasenote" class="dsettings" data-id="_purchase_note" type="checkbox"><label for="dpurchasenote"> <?php echo $arrTranslated['_purchase_note']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dpurchasenote_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="d_grouped_items" class="dsettings" data-id="grouped_items" type="checkbox"><label for="d_grouped_items"> <?php echo $arrTranslated['grouped_items']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_grouped_items_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="d_product_adminlink" class="dsettings" data-id="_product_adminlink" type="checkbox"><label for="d_product_adminlink"> Edit in admin</label>
					</td>
					<td>
						<div>
						 <img id="d_product_adminlink_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dproductstatus" class="dsettings" data-id="post_status" type="checkbox"><label for="dproductstatus"> <?php echo $arrTranslated['post_status']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dproductstatus_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dcatalog" class="dsettings" data-id="_visibility" type="checkbox"><label for="dcatalog"> <?php echo $arrTranslated['_visibility']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dcatalog_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="d_upsell_ids" class="dsettings" data-id="_upsell_ids" type="checkbox"><label for="d_upsell_ids"> <?php echo $arrTranslated['_upsell_ids']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_upsell_ids_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="d_crosssell_ids" class="dsettings" data-id="_crosssell_ids" type="checkbox"><label for="d_crosssell_ids"> <?php echo $arrTranslated['_crosssell_ids']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_crosssell_ids_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="ddownloadable" class="dsettings" data-id="_downloadable" type="checkbox"><label for="ddownloadable"> <?php echo $arrTranslated['_downloadable']; ?></label>
					</td>
					<td>
						<div>
						 <img id="ddownloadable_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dvirtual" class="dsettings" data-id="_virtual" type="checkbox"><label for="dvirtual"> <?php echo $arrTranslated['_virtual']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dvirtual_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="ddownexpiry" class="dsettings" data-id="_download_expiry" type="checkbox"><label for="ddownexpiry"> <?php echo $arrTranslated['_download_expiry']; ?></label>
					</td>
					<td>
						<div>
						 <img id="ddownexpiry_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="ddownlimit" class="dsettings" data-id="_download_limit" type="checkbox"><label for="ddownlimit">  <?php echo $arrTranslated['_download_limit']; ?></label>
					</td>
					<td>
						<div>
						 <img id="ddownlimit_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="ddownfiles" class="dsettings" data-id="_downloadable_files" type="checkbox"><label for="ddownfiles"> <?php echo $arrTranslated['_downloadable_files']; ?></label>
					</td>
					<td>
						<div>
						 <img id="ddownfiles_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="ddowntype" class="dsettings" data-id="_download_type" type="checkbox"><label for="ddowntype"> <?php echo $arrTranslated['_download_type']; ?></label>
					</td>
					<td>
						<div>
						 <img id="ddowntype_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="d_product_url" class="dsettings" data-id="_product_url" type="checkbox"><label for="d_product_url"> <?php echo $arrTranslated['_product_url']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_product_url_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="d_button_text" class="dsettings" data-id="_button_text" type="checkbox"><label for="d_button_text"> <?php echo $arrTranslated['_button_text']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_button_text_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dproduct_type" class="dsettings" data-id="product_type" type="checkbox"><label for="dproduct_type"> <?php echo $arrTranslated['product_type']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dproduct_type_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="dcomment_status" class="dsettings" data-id="comment_status" type="checkbox"><label for="dcomment_status"> <?php echo $arrTranslated['comment_status']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dcomment_status_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="d_product_permalink" class="dsettings" data-id="_product_permalink" type="checkbox"><label for="d_product_permalink"> Product URL (permalink)</label>
					</td>
					<td>
						<div>
						 <img id="d_product_permalink_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="d_default_attributes" class="dsettings" data-id="_default_attributes" type="checkbox"><label for="d_default_attributes"> <?php echo $arrTranslated['_default_attributes']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_default_attributes_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="d_custom_attributes" class="dsettings" data-id="_custom_attributes" type="checkbox"><label for="d_custom_attributes"> <?php echo $arrTranslated['_custom_attributes']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_custom_attributes_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						<input id="d_variation_description" class="dsettings" data-id="_variation_description" type="checkbox"><label for="d_variation_description"> <?php echo $arrTranslated['_variation_description']; ?></label>
					</td>
					<td>
						<div>
						 <img id="d_variation_description_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<input id="dpost_author" class="dsettings" data-id="post_author" type="checkbox"><label for="dpost_author"> <?php echo $arrTranslated['post_author']; ?></label>
					</td>
					<td>
						<div>
						 <img id="dpost_author_check" src="<?php echo $purl;?>images/tick.png" style="visibility:hidden;"/>
						</div>
					</td>
					<td>
						&nbsp;
					</td>
					<td>
						&nbsp;
					</td>
				</tr>
				<?php
					$counter = 0;
					foreach($this->attributes as $attr)
					{
						if($counter % 2 == 0)
						{
							echo '<tr><td>';
						}else
						{
							echo '<td>';
						}
						$attr_slug = "attribute_pa_".$attr->name;
						echo '<input id="d'.$attr_slug.'" class="dsettings" data-id="'.$attr_slug.'" type="checkbox"><label for="d'.$attr_slug.'"> (attr) '.$attr->label.'</label>
					</td>
					<td>
						<div>
						 <img id="d'.$attr_slug.'_check" src="'.$purl.'images/tick.png" style="visibility:hidden;"/>
						</div>';
						if($counter % 2 == 0)
						{
							$endrow = false;
							echo '</td>';
						}else
						{
							$endrow = true;
							echo '</td></tr>';
						}
						$counter++;
					}
				?>
			</table>
			<br/>
			</div>
			<!--//table views-->
			<div id="dialogtableviews">
				<table cellpadding="0" cellspacing="0" id="tableviews" class="tableviews-ext">
					<tr>
						<td style="width:35%;">
						<label><input type="radio" name="viewdialog" value="savenew" class="viewdialog-radio-ext">
							 <?php esc_html_e( 'Save to new view', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td colspan="2"><input type="text" id="viewinputnew"></input></td>
					</tr>
					<tr>
						<td style="width:35%;">
						<label><input type="radio" name="viewdialog" value="load" checked="checked" class="viewdialog-radio-ext">
							 <?php esc_html_e( 'Load existing view', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td colspan="2"><select id="viewselectload"><option value="">none</option></select> </td>
					</tr>
					<tr>
						<td style="width:35%;">
						<label><input type="radio" name="viewdialog" value="save" class="viewdialog-radio-ext">
							<?php esc_html_e( 'Save to exisiting view /replace/', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td colspan="2"><select id="viewselectreplace"><option value="">none</option></select></td>
					</tr>

					<tr>
						<td style="width:35%;border-bottom: none;">
						<label><input type="radio" name="viewdialog" value="edit" class="viewdialog-radio-ext">
							<?php esc_html_e( 'Edit View List', 'woocommerce-advbulkedit'); ?></label>
						</td>
						<td>
							<select id="viewselectedit"><option value="">none</option></select>
						</td>
						<td style="border-bottom: none;">
							<p><?php esc_html_e( 'Rename', 'woocommerce-advbulkedit'); ?>  to <input type="text" id="viewinputnewname"></input> <button id="buttonviewrename" class="button-wcabe"><?php esc_html_e( 'Apply', 'woocommerce-advbulkedit'); ?></button></p>
							<hr>
							<p><button id="buttonviewdelete" class="button-wcabe button-warning-wcabe"><?php echo mb_convert_case(esc_html__( "delete view", "woocommerce-advbulkedit"), MB_CASE_TITLE, "UTF-8"); ?></button></p>
						</td>
					</tr>
				</table>
			</div>
			<!--//built-in taxonomies select-->
			<div id="categoriesdialog">
				<div class="grouped_items">
				<?php
					$classname = "clearothers";
					if($this->isversion3 )
						$classname = "clearothersgrouped";
				?>
					<ul class="categorychecklist form-no-clear <?php echo $classname; ?>">
						<li><label class="selectit"><input value="0" type="checkbox"  /> Choose a grouped product...</label></li>
					<?php
						$argsgr = array(
							'posts_per_page'   => 1000,
							'post_type' => 'product',
							'product_type' => 'grouped'
						);
						$query = new WP_Query( $argsgr );

						// The Loop
						while ( $query->have_posts() ) {
							$query->the_post();
							echo '<li><label class="selectit"><input value="'.$query->post->ID.'" type="checkbox" data-name="'.addslashes(get_the_title()).'" />'.get_the_title().'</label></li>';
						}
						wp_reset_postdata();
					?>
					</ul>
				</div>
				<div class='product_cat'>
					<?php
							$args = array(
							'descendants_and_self'  => 0,
							'selected_cats'         => false,
							'popular_cats'          => false,
							'walker'                => null,
							'taxonomy'              => 'product_cat',
							'checked_ontop'         => true
						);

						?>

					<?php

						if (file_exists( __DIR__.'/integrations/catnames-to-ids.php')) {
							require_once('integrations/catnames-to-ids.php');
							$args = array(
								'descendants_and_self'  => 0,
								'selected_cats'         => false,
								'popular_cats'          => false,
								'walker'                =>
									class_exists('W3ExABulkEdit_Walker_CategoryNamesToIDs_Checklist') ? new W3ExABulkEdit_Walker_CategoryNamesToIDs_Checklist() : null,
								'taxonomy'              => 'product_cat',
								'checked_ontop'         => true
							);
						}

                    ?>
					<ul class="categorychecklist form-no-clear">
							<?php wp_terms_checklist( 0, $args ); ?>
					</ul>
				</div>
				<div class='product_tag'>
					<?php
							$args = array(
							'descendants_and_self'  => 0,
							'selected_cats'         => false,
							'popular_cats'          => false,
							'walker'                => null,
							'taxonomy'              => 'product_tag',
							'checked_ontop'         => true
						);

						?>
					<ul class="categorychecklist form-no-clear">
							<!--uncomment php below for hiearchical tags-->
							<?php
								wp_terms_checklist( 0, $args );
							?>
					</ul>
				</div>
				<div class='product_shipping_class'>
					<?php
							$args = array(
							'descendants_and_self'  => 0,
							'selected_cats'         => false,
							'popular_cats'          => false,
							'walker'                => null,
							'taxonomy'              => 'product_shipping_class',
							'checked_ontop'         => true
						);

					?>
					<ul class="categorychecklist form-no-clear clearothers">
					<li id="product_shipping_class-none">
    					<label class="selectit">
					        <input id="in-product_shipping_class-none" type="checkbox" name="tax_input[product_shipping_class][]" value=""></input>
					         None
					    </label>
					</li>
							<?php wp_terms_checklist( 0, $args ); ?>
					</ul>
				</div>
				<div class='product_type'>
					<?php
							$args = array(
							'descendants_and_self'  => 0,
							'selected_cats'         => false,
							'popular_cats'          => false,
							'walker'                => null,
							'taxonomy'              => 'product_type',
							'checked_ontop'         => true
						);

					?>
					<ul class="categorychecklist form-no-clear clearothers">
							<?php wp_terms_checklist( 0, $args ); ?>
					</ul>
				</div>
				<div class='post_author'>
					<ul class="categorychecklist form-no-clear clearothers">
							<?php
							foreach ( $blogusers as $user )
							{
								echo '<li>
				    					<label class="selectit">
									        <input value="'.$user->ID.'" type="checkbox">
									        '.$user->display_name.'
									    </label>
									</li>'
								;
							}

							 ?>
					</ul>
				</div>

				<?php
					if(is_array($this->attributes) && !empty($this->attributes))
					{
						$allattrs = '<div id="allattributeslist"><ul>';
						foreach($this->attributes as $attr)
						{
							if(count($attr->values) > 2000)
								continue;
							echo '<div class="attribute_pa_'.$attr->name.'">';
							$allattrs.= '<li><label><input type="checkbox" data-label="'.$attr->label.'" value="attribute_pa_'.$attr->name.'">'.$attr->label.'</label></li>';
							$args = array(
								'descendants_and_self'  => 0,
								'selected_cats'         => false,
								'popular_cats'          => false,
								'walker'                => null,
								'taxonomy'              => 'pa_'.$attr->name,
								'checked_ontop'         => true
							);
							echo '<ul class="categorychecklist form-no-clear">';
							
							if (!empty($attr->name)) {
								wp_terms_checklist( 0, $args );
							}

							echo '</ul>';
							echo '</div>';
					    }
						$allattrs.= '</ul></div>';
						echo $allattrs;
					}
				?>
				<?php
					if(is_array($sel_fields) && !empty($sel_fields))
					{
						foreach($sel_fields as $key => $innerarray)
						{
							if(isset($innerarray['type']))
							{
								if($innerarray['type'] === 'customh')
								{
									if(taxonomy_exists($key))
									{
										echo '<div class="'.$key.'">';
										echo PHP_EOL;

										if($key === 'product_sale_labels' || $key === 'product_delivery_times')
										{
											echo '<ul class="categorychecklist form-no-clear clearothers">';
										}else
										{
											echo '<ul class="categorychecklist form-no-clear">';
										}
										$args = array(
											'descendants_and_self'  => 0,
											'selected_cats'         => false,
											'popular_cats'          => false,
											'walker'                => null,
											'taxonomy'              => $key,
											'checked_ontop'         => true
										);
										wp_terms_checklist( 0, $args );
										echo '</ul></div>';
									}
								}
							}
						}
					}
				?>
			</div>
			<?php
				if(is_array($this->attributes) && !empty($this->attributes) && $skiploadfrontpage)
				{
					echo '<script>';
					foreach($this->attributes as $attr)
					{
						$attr_label = substr($attr->label,0,100);
						$attr_label = preg_replace('/\s+/', ' ', trim($attr_label));
						$key = "attribute_pa_".$attr->name;
						$bulktext = '<tr data-id="'.$key.'"><td>'
						.'<input id="set'.$key.'" type="checkbox" class="bulkset" data-id="'.$key.'" data-type="customtaxh"><label for="set'.$key.'">Set (attr) '.$attr_label.'</label></td><td>'.
						'<select id="bulkadd'.$key.'" class="bulkselect">'.
							'<option value="new">'.esc_html__('set new','woocommerce-advbulkedit').'</option>'.
							'<option value="add">'.esc_html__('add','woocommerce-advbulkedit').'</option>'.
							'<option value="remove">'.esc_html__('remove','woocommerce-advbulkedit').'</option></select><button class="butnewattribute button-wcabe button-be-wcabe" type="button"><span class="icon-plus-outline"></span>new</button><div class="divnewattribute">'
		   .'<input class="inputnewattributename" type="text" placeholder="name" data-slug="'.$key.'"></input><br/>'
		   .'<input class="inputnewattributeslug" type="text" placeholder="slug (optional)"></input><br/>'
		   .'<button class="butnewattributesave butbulkdialog" style="position:relative;">Ok</button><button class="butnewattributecancel">Cancel</button></div>'
		   .'<div class="divnewattributeerror"></div></td><td class="nontextnumbertd">'
						 .'<select id="bulk'.$key.'" class="makechosen catselset" style="width:250px;" data-placeholder="'.str_replace('\\','\\\\',$arrTranslated['trans_data_placeholder']).'" multiple ><option value=""></option>';

						foreach($attr->values as $value)
						{
							$val_name = substr($value->name,0,100);
							$val_name = preg_replace('/\s+/', ' ', trim($val_name));
							$bulktext.= '<option value="'.$value->term_id.'">'.$val_name.'</option>';
						}
						$bulktext.= '</select></td><td>(<select class="selectvisiblefp" disabled data-id="'.$key.'">'.
						'<option value="skip">skip</option><option value="andset">and set</option><option value="onlyset">only set</option>'.
						'</select>&nbsp;<input type="checkbox" disabled class="visiblefp" data-id="'.$key.'">Visible on p. p.)&nbsp;&nbsp;'.
						'(<select disabled class="selectusedforvars" data-id="'.$key.'"><option value="skip">skip</option><option value="andset">and set</option><option value="onlyset">only set</option>'.
						'</select>&nbsp;<input type="checkbox" disabled class="usedforvars" data-id="'.$key.'">Used for var.)</td></tr>';
						echo "W3Ex['".str_replace("'","\'",$key)."bulk'] = '".str_replace("'","\'",$bulktext)."';";
						echo PHP_EOL;
					}
					echo '</script>';
				}
				if(is_array($sel_fields) && !empty($sel_fields))
				{
					echo PHP_EOL;
					echo '<script>';
					foreach($sel_fields as $key => $innerarray)
					{
						if(isset($innerarray['type']))
						{
							if($innerarray['type'] === 'customh' || $innerarray['type'] === 'custom')
							{
								if(taxonomy_exists($key))
								{

									$bulktext = '<tr data-id="'.$key.'"><td>'
									.'<input id="set'.$key.'" type="checkbox" class="bulkset" data-id="'.$key.'" data-type="customtaxh"><label for="set'.$key.'">Set '.$key.'</label></td><td>'.
						'<select id="bulkadd'.$key.'" class="bulkselect">'.
							'<option value="new">'.esc_html__('set new','woocommerce-advbulkedit').'</option>'.
							'<option value="add">'.esc_html__('add','woocommerce-advbulkedit').'</option>'.
							'<option value="remove">'.esc_html__('remove','woocommerce-advbulkedit').'</option></select>'.
							'<button class="butnewattribute button newcat" type="button"><span class="icon-plus-outline"></span>new</button>'.
						'<div class="divnewattribute">' .
		   '<input class="inputnewattributename" type="text" placeholder="name" data-slug="'.$key.'"></input><br/> '.
		  '<input class="inputnewattributeslug" type="text" placeholder="slug (optional)"></input><br/>'.
		   '<select class="selectnewcategory" data-placeholder="select parent(optional)" multiple></select><br/>'.
		   '<button class="butnewattributesave butbulkdialog newcat" style="position:relative;">Ok</button><button class="butnewattributecancel newcat">Cancel</button></div>'.
		   '<div class="divnewattributeerror"></div>'.
							'</td><td class="nontextnumbertd">'
									 .'<select id="bulk'.$key.'" class="makechosen catselset" style="width:250px;" data-placeholder="'.str_replace('\\','\\\\',$arrTranslated['trans_data_placeholder']).'" multiple ><option value=""></option>';
									 $searchtext = ' class="makechosen catselset" style="width:250px;" data-placeholder="'.str_replace('\\','\\\\',$arrTranslated['trans_data_placeholder']).'" multiple ><option value=""></option>';
									   $argsb = array(
									    'number'     => 99999,
									    'orderby'    => 'slug',
									    'order'      => 'ASC',
									    'hide_empty' => false,
									    'include'    => '',
										'fields'     => 'all'
									);

									$woo_categoriesb = get_terms($key, $argsb );
									if(is_wp_error($woo_categoriesb))
											continue;
									foreach($woo_categoriesb as $category)
									{
									    if(!is_object($category)) continue;
									    if(!property_exists($category,'name')) continue;
									    if(!property_exists($category,'term_id')) continue;
										if(!property_exists($category,'term_taxonomy_id')) continue;
										$catname = str_replace('"','\"',$category->name);
										$catname = trim(preg_replace('/\s+/', ' ', $catname));
									   	$bulktext.= '<option value="'.$category->term_id.'" >'.$catname.'</option>';
										$searchtext.= '<option value="'.$category->term_taxonomy_id.'" >'.$catname.'</option>';
									}
									$bulktext.= '</select></td><td></td></tr>';
									$searchtext.= '</select>';
									if($innerarray['type'] === 'customh')
									{
										echo "W3Ex['".str_replace("'","\'",$key)."bulk'] = '".str_replace("'","\'",$bulktext)."';";
									}
									echo "W3Ex['taxonomyterms".str_replace("'","\'",$key)."'] = '".str_replace("'","\'",$searchtext)."';";
									echo PHP_EOL;
								}
							}
						}
					}

					echo '</script>';
				}
			?>
			<?php
			//add shipping class
				echo PHP_EOL;
				echo '<script>';
				$key = 'product_shipping_class';
				$searchtext = ' class="makechosen catselset" style="width:250px;" data-placeholder="select" multiple ><option value="none">none</option>';
				   $argsb = array(
				    'number'     => 99999,
				    'orderby'    => 'slug',
				    'order'      => 'ASC',
				    'hide_empty' => false,
				    'include'    => '',
					'fields'     => 'all'
				);

				$woo_categoriesb = get_terms($key, $argsb );

				foreach($woo_categoriesb as $category)
				{
				    if(!is_object($category)) continue;
				    if(!property_exists($category,'name')) continue;
				    if(!property_exists($category,'term_taxonomy_id')) continue;
					$catname = str_replace('"','\"',$category->name);
					$catname = trim(preg_replace('/\s+/', ' ', $catname));
					$searchtext.= '<option value="'.$category->term_taxonomy_id.'" >'.$catname.'</option>';
				}
				$searchtext.= '</select>';

				echo "W3Ex['taxonomyterms".str_replace("'","\'",$key)."'] = '".str_replace("'","\'",$searchtext)."';";

				$key = 'post_author';
				$searchtext = ' class="makechosen catselset" style="width:250px;" data-placeholder="select" multiple >';


				foreach ( $blogusers as $user )
				{
					$catname = str_replace('"','\"',$user->display_name);
					$catname = trim(preg_replace('/\s+/', ' ', $catname));
					$searchtext.= '<option value="'.$user->ID.'" >'.$catname.'</option>';
				}

				$searchtext.= '</select>';

				echo "W3Ex['taxonomyterms".str_replace("'","\'",$key)."'] = '".str_replace("'","\'",$searchtext)."';";

				$key = 'product_type';
				$searchtext = ' class="makechosen catselset" style="width:250px;" data-placeholder="select" multiple >';
				   $argsb = array(
				    'number'     => 99999,
				    'orderby'    => 'slug',
				    'order'      => 'ASC',
				    'hide_empty' => false,
				    'include'    => '',
					'fields'     => 'all'
				);

				$woo_categoriesb = get_terms($key, $argsb );

				foreach($woo_categoriesb as $category)
				{
				    if(!is_object($category)) continue;
				    if(!property_exists($category,'name')) continue;
				    if(!property_exists($category,'term_taxonomy_id')) continue;
					$catname = str_replace('"','\"',$category->name);
					$catname = trim(preg_replace('/\s+/', ' ', $catname));
					$searchtext.= '<option value="'.$category->term_taxonomy_id.'" >'.$catname.'</option>';
				}
				$searchtext.= '</select>';

				echo "W3Ex['taxonomyterms".str_replace("'","\'",$key)."'] = '".str_replace("'","\'",$searchtext)."';";
				echo '</script>';
				echo PHP_EOL;
			?>
			<!--//custom fields dialog-->
			<div id="customfieldsdialog">
			<table cellpadding="10" cellspacing="0" id="customfieldstable">
				<tr class="addcontrols">
					<td>
						Meta key/tax. slug:<br />
						<input id="fieldname" type="text"/>
					</td>
					<td>
						Field name(display as):<br />
						<input id="fieldname1" type="text"/>
					</td>
					<td>
						Field type:<br />
						<select id="fieldtype">
							<option value="text">Text (single line)</option>
							<option value="multitext">Text (multi line)</option>
							<option value="integer">Number (integer)</option>
							<option value="decimal">Number (decimal .00)</option>
							<option value="decimal3">Number (decimal .000)</option>
							<option value="select">Dropdown Select</option>
							<option value="checkbox">Checkbox</option>
							<option value="datetime">DateTime</option>
							<option value="custom">Custom taxonomy</option>
							<option value="customh">Custom taxonomy (hierarchical)</option>
							<?php
							if (file_exists( __DIR__.'/integrations/acf-custom-fields-customizations-for-viktor.php')) {
								require_once('integrations/acf-custom-fields-customizations-for-viktor.php');
								W3ExABulkEdit_Integ_ACFCustomFieldsCustomizationsForViktor::the_custom_field_html();
							}
							?>
							<option value="url">URL</option>
							<option value="serialized-to-csv">Serialized to CSV</option>
                            <option value="serialized-to-csv-2">Serialized to CSV 2</option>
						</select>
					</td>
					<td>
						Visible:<br />
						<select id="fieldvisible">
							<option value="yes">Yes</option>
							<option value="no">No</option>
						</select>
					</td>
				</tr>
				<tr class="addokcancel">
					<td>
						 <button id="addok" class="button-wcabe">Ok</button>&nbsp;&nbsp;&nbsp;&nbsp;
						 <button id="addcancel" class="button-wcabe">Cancel</button>
					</td>
					<td><div id="extracustominfo"></div>
					</td>
					<td>
					</td>
				</tr>
			</table><br />
			 <button id="addcustomfield" class="button-wcabe"><?php esc_html_e( 'Add Custom Field', 'woocommerce-advbulkedit'); ?></button>
		</div>
		<div id="findcustomfieldsdialog">
			 <p><?php esc_html_e( "Use the tools below to import custom/meta fields or taxonomies. Check the ones you want to add for bulk editing in the products table. When ready, don't forget to click 'Save Selected and Close'.", 'woocommerce-advbulkedit'); ?></p>
			 <button id="findcustomfieldsauto" class="button-primary-wcabe"><?php esc_html_e('Find Custom/Meta Fields','woocommerce-advbulkedit'); ?></button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <button id="findcustomtaxonomies" class="button-wcabe"><?php esc_html_e('Find Taxonomies','woocommerce-advbulkedit'); ?></button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <input id="productid" type="search" placeholder="<?php esc_html_e('Find custom/meta fields by product ID','woocommerce-advbulkedit'); ?>"/> <button id="findcustomfield" class="button-wcabe"><?php esc_html_e('Find','woocommerce-advbulkedit'); ?></button>
			 <br /><br /><br />
			 <table cellpadding="25" cellspacing="0" class="tablecustomfields">
			</table>
		</div>
		<div id="debuginfo"></div>
			<iframe id="exportiframe" width="0" height="0">
  			</iframe>


		<div id="memorylimit">
		</div>
		<div id="memoryusage">
		<?php
		if(isset($settings['debugmode']))
		{
			if($settings['debugmode'] == 1)
			{
				if(function_exists('memory_get_usage'))
				{
					$usage = memory_get_usage();
					echo 'Memory usage: '.round($usage /(1024 * 1024),2).'M';
				}
			}
		}?>
		</div>
        <div id="phpver">
            <?php
                if(isset($settings['debugmode']))
                {
                    if($settings['debugmode'] == 1)
                    {
                        echo 'PHP Memory Limit: '.ini_get('memory_limit');
                        echo '<br>PHP Version: '.phpversion();
                    }
                }?>
        </div>
		<div id="editorcontainer">
			 <?php
				 $settingsed = array( 'textarea_name' => 'post_text' );
				 wp_editor("", "editorid",$settingsed );
			 ?>
			<textarea style="display:none;" name="post_text" id="editorid" rows="3"></textarea>
			<DIV style='text-align:right' id="savewordpeditor"><BUTTON>Save</BUTTON><BUTTON id="cancelwordpeditor">Cancel</BUTTON></DIV>
			</div>
		</div>

		<div id="split-variations-dlg" class="hidden">
			<p><?php esc_html_e('Transform all selected variations to simple products?','woocommerce-advbulkedit'); ?></p>
			<p><em><?php esc_html_e('Note: Each of the selected variations will be deleted, after transfering to a simple product.','woocommerce-advbulkedit'); ?></em></p>

			<div id="split-variations-advanced-options">
				<h3><?php esc_html_e('Advanced options','woocommerce-advbulkedit'); ?></h3>
				<div>
					<p><?php esc_html_e('By default all custom fields will be copied from the variation to the new simple product.','woocommerce-advbulkedit'); ?></p>
					<p><?php esc_html_e('To instead copy only a selection of the custom fields from the parent product, please choose:','woocommerce-advbulkedit'); ?></p>
					<h4><?php esc_html_e('Custom fields to copy from the parent product:','woocommerce-advbulkedit'); ?></h4>
					<ul id="split-variations-advanced-options-parent-custom-fields"></ul>
				</div>
			</div>
		</div>

		<?php

	}


    public function _main()
    {
		$this->showMainPage();
    }
}

W3ExAdvBulkEditView::init();
